/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.EntityTypesListCopier;
import software.amazon.awssdk.services.comprehend.model.EntityTypesListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityRecognitionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityRecognitionConfig> {
    private static final SdkField<List<EntityTypesListItem>> ENTITY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntityTypes").getter(EntityRecognitionConfig.getter(EntityRecognitionConfig::entityTypes)).setter(EntityRecognitionConfig.setter(Builder::entityTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntityTypesListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<EntityTypesListItem> entityTypes;

    private EntityRecognitionConfig(BuilderImpl builder) {
        this.entityTypes = builder.entityTypes;
    }

    public final boolean hasEntityTypes() {
        return this.entityTypes != null && !(this.entityTypes instanceof SdkAutoConstructList);
    }

    public final List<EntityTypesListItem> entityTypes() {
        return this.entityTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityTypes() ? this.entityTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityRecognitionConfig)) {
            return false;
        }
        EntityRecognitionConfig other = (EntityRecognitionConfig)obj;
        return this.hasEntityTypes() == other.hasEntityTypes() && Objects.equals(this.entityTypes(), other.entityTypes());
    }

    public final String toString() {
        return ToString.builder((String)"EntityRecognitionConfig").add("EntityTypes", this.hasEntityTypes() ? this.entityTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityTypes": {
                return Optional.ofNullable(clazz.cast(this.entityTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityRecognitionConfig, T> g) {
        return obj -> g.apply((EntityRecognitionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EntityTypesListItem> entityTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EntityRecognitionConfig model) {
            this.entityTypes(model.entityTypes);
        }

        public final List<EntityTypesListItem.Builder> getEntityTypes() {
            List<EntityTypesListItem.Builder> result = EntityTypesListCopier.copyToBuilder(this.entityTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntityTypes(Collection<EntityTypesListItem.BuilderImpl> entityTypes) {
            this.entityTypes = EntityTypesListCopier.copyFromBuilder(entityTypes);
        }

        @Override
        public final Builder entityTypes(Collection<EntityTypesListItem> entityTypes) {
            this.entityTypes = EntityTypesListCopier.copy(entityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypes(EntityTypesListItem ... entityTypes) {
            this.entityTypes(Arrays.asList(entityTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypes(Consumer<EntityTypesListItem.Builder> ... entityTypes) {
            this.entityTypes(Stream.of(entityTypes).map(c -> (EntityTypesListItem)((EntityTypesListItem.Builder)EntityTypesListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EntityRecognitionConfig build() {
            return new EntityRecognitionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityRecognitionConfig> {
        public Builder entityTypes(Collection<EntityTypesListItem> var1);

        public Builder entityTypes(EntityTypesListItem ... var1);

        public Builder entityTypes(Consumer<EntityTypesListItem.Builder> ... var1);
    }
}

