/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The evaluation metrics associated with the evaluated model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlywheelModelEvaluationMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<FlywheelModelEvaluationMetrics.Builder, FlywheelModelEvaluationMetrics> {
    private static final SdkField<Double> AVERAGE_F1_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("AverageF1Score").getter(getter(FlywheelModelEvaluationMetrics::averageF1Score))
            .setter(setter(Builder::averageF1Score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageF1Score").build()).build();

    private static final SdkField<Double> AVERAGE_PRECISION_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("AveragePrecision").getter(getter(FlywheelModelEvaluationMetrics::averagePrecision))
            .setter(setter(Builder::averagePrecision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AveragePrecision").build()).build();

    private static final SdkField<Double> AVERAGE_RECALL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("AverageRecall").getter(getter(FlywheelModelEvaluationMetrics::averageRecall))
            .setter(setter(Builder::averageRecall))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageRecall").build()).build();

    private static final SdkField<Double> AVERAGE_ACCURACY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("AverageAccuracy").getter(getter(FlywheelModelEvaluationMetrics::averageAccuracy))
            .setter(setter(Builder::averageAccuracy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageAccuracy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVERAGE_F1_SCORE_FIELD,
            AVERAGE_PRECISION_FIELD, AVERAGE_RECALL_FIELD, AVERAGE_ACCURACY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double averageF1Score;

    private final Double averagePrecision;

    private final Double averageRecall;

    private final Double averageAccuracy;

    private FlywheelModelEvaluationMetrics(BuilderImpl builder) {
        this.averageF1Score = builder.averageF1Score;
        this.averagePrecision = builder.averagePrecision;
        this.averageRecall = builder.averageRecall;
        this.averageAccuracy = builder.averageAccuracy;
    }

    /**
     * <p>
     * The average F1 score from the evaluation metrics.
     * </p>
     * 
     * @return The average F1 score from the evaluation metrics.
     */
    public final Double averageF1Score() {
        return averageF1Score;
    }

    /**
     * <p>
     * Average precision metric for the model.
     * </p>
     * 
     * @return Average precision metric for the model.
     */
    public final Double averagePrecision() {
        return averagePrecision;
    }

    /**
     * <p>
     * Average recall metric for the model.
     * </p>
     * 
     * @return Average recall metric for the model.
     */
    public final Double averageRecall() {
        return averageRecall;
    }

    /**
     * <p>
     * Average accuracy metric for the model.
     * </p>
     * 
     * @return Average accuracy metric for the model.
     */
    public final Double averageAccuracy() {
        return averageAccuracy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(averageF1Score());
        hashCode = 31 * hashCode + Objects.hashCode(averagePrecision());
        hashCode = 31 * hashCode + Objects.hashCode(averageRecall());
        hashCode = 31 * hashCode + Objects.hashCode(averageAccuracy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlywheelModelEvaluationMetrics)) {
            return false;
        }
        FlywheelModelEvaluationMetrics other = (FlywheelModelEvaluationMetrics) obj;
        return Objects.equals(averageF1Score(), other.averageF1Score())
                && Objects.equals(averagePrecision(), other.averagePrecision())
                && Objects.equals(averageRecall(), other.averageRecall())
                && Objects.equals(averageAccuracy(), other.averageAccuracy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlywheelModelEvaluationMetrics").add("AverageF1Score", averageF1Score())
                .add("AveragePrecision", averagePrecision()).add("AverageRecall", averageRecall())
                .add("AverageAccuracy", averageAccuracy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AverageF1Score":
            return Optional.ofNullable(clazz.cast(averageF1Score()));
        case "AveragePrecision":
            return Optional.ofNullable(clazz.cast(averagePrecision()));
        case "AverageRecall":
            return Optional.ofNullable(clazz.cast(averageRecall()));
        case "AverageAccuracy":
            return Optional.ofNullable(clazz.cast(averageAccuracy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlywheelModelEvaluationMetrics, T> g) {
        return obj -> g.apply((FlywheelModelEvaluationMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlywheelModelEvaluationMetrics> {
        /**
         * <p>
         * The average F1 score from the evaluation metrics.
         * </p>
         * 
         * @param averageF1Score
         *        The average F1 score from the evaluation metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder averageF1Score(Double averageF1Score);

        /**
         * <p>
         * Average precision metric for the model.
         * </p>
         * 
         * @param averagePrecision
         *        Average precision metric for the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder averagePrecision(Double averagePrecision);

        /**
         * <p>
         * Average recall metric for the model.
         * </p>
         * 
         * @param averageRecall
         *        Average recall metric for the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder averageRecall(Double averageRecall);

        /**
         * <p>
         * Average accuracy metric for the model.
         * </p>
         * 
         * @param averageAccuracy
         *        Average accuracy metric for the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder averageAccuracy(Double averageAccuracy);
    }

    static final class BuilderImpl implements Builder {
        private Double averageF1Score;

        private Double averagePrecision;

        private Double averageRecall;

        private Double averageAccuracy;

        private BuilderImpl() {
        }

        private BuilderImpl(FlywheelModelEvaluationMetrics model) {
            averageF1Score(model.averageF1Score);
            averagePrecision(model.averagePrecision);
            averageRecall(model.averageRecall);
            averageAccuracy(model.averageAccuracy);
        }

        public final Double getAverageF1Score() {
            return averageF1Score;
        }

        public final void setAverageF1Score(Double averageF1Score) {
            this.averageF1Score = averageF1Score;
        }

        @Override
        public final Builder averageF1Score(Double averageF1Score) {
            this.averageF1Score = averageF1Score;
            return this;
        }

        public final Double getAveragePrecision() {
            return averagePrecision;
        }

        public final void setAveragePrecision(Double averagePrecision) {
            this.averagePrecision = averagePrecision;
        }

        @Override
        public final Builder averagePrecision(Double averagePrecision) {
            this.averagePrecision = averagePrecision;
            return this;
        }

        public final Double getAverageRecall() {
            return averageRecall;
        }

        public final void setAverageRecall(Double averageRecall) {
            this.averageRecall = averageRecall;
        }

        @Override
        public final Builder averageRecall(Double averageRecall) {
            this.averageRecall = averageRecall;
            return this;
        }

        public final Double getAverageAccuracy() {
            return averageAccuracy;
        }

        public final void setAverageAccuracy(Double averageAccuracy) {
            this.averageAccuracy = averageAccuracy;
        }

        @Override
        public final Builder averageAccuracy(Double averageAccuracy) {
            this.averageAccuracy = averageAccuracy;
            return this;
        }

        @Override
        public FlywheelModelEvaluationMetrics build() {
            return new FlywheelModelEvaluationMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
