/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendClient;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse;

public class ListSentimentDetectionJobsIterable
implements SdkIterable<ListSentimentDetectionJobsResponse> {
    private final ComprehendClient client;
    private final ListSentimentDetectionJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSentimentDetectionJobsIterable(ComprehendClient client, ListSentimentDetectionJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSentimentDetectionJobsResponseFetcher();
    }

    public Iterator<ListSentimentDetectionJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSentimentDetectionJobsResponseFetcher
    implements SyncPageFetcher<ListSentimentDetectionJobsResponse> {
        private ListSentimentDetectionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListSentimentDetectionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSentimentDetectionJobsResponse nextPage(ListSentimentDetectionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListSentimentDetectionJobsIterable.this.client.listSentimentDetectionJobs(ListSentimentDetectionJobsIterable.this.firstRequest);
            }
            return ListSentimentDetectionJobsIterable.this.client.listSentimentDetectionJobs((ListSentimentDetectionJobsRequest)((Object)ListSentimentDetectionJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

