/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.EntityRecognizerInputDataConfig;
import software.amazon.awssdk.services.comprehend.model.EntityRecognizerMetadata;
import software.amazon.awssdk.services.comprehend.model.LanguageCode;
import software.amazon.awssdk.services.comprehend.model.ModelStatus;
import software.amazon.awssdk.services.comprehend.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityRecognizerProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityRecognizerProperties> {
    private static final SdkField<String> ENTITY_RECOGNIZER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityRecognizerArn").getter(EntityRecognizerProperties.getter(EntityRecognizerProperties::entityRecognizerArn)).setter(EntityRecognizerProperties.setter(Builder::entityRecognizerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityRecognizerArn").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(EntityRecognizerProperties.getter(EntityRecognizerProperties::languageCodeAsString)).setter(EntityRecognizerProperties.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(EntityRecognizerProperties.getter(EntityRecognizerProperties::statusAsString)).setter(EntityRecognizerProperties.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(EntityRecognizerProperties.getter(EntityRecognizerProperties::message)).setter(EntityRecognizerProperties.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Instant> SUBMIT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubmitTime").getter(EntityRecognizerProperties.getter(EntityRecognizerProperties::submitTime)).setter(EntityRecognizerProperties.setter(Builder::submitTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(EntityRecognizerProperties.getter(EntityRecognizerProperties::endTime)).setter(EntityRecognizerProperties.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Instant> TRAINING_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TrainingStartTime").getter(EntityRecognizerProperties.getter(EntityRecognizerProperties::trainingStartTime)).setter(EntityRecognizerProperties.setter(Builder::trainingStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingStartTime").build()}).build();
    private static final SdkField<Instant> TRAINING_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TrainingEndTime").getter(EntityRecognizerProperties.getter(EntityRecognizerProperties::trainingEndTime)).setter(EntityRecognizerProperties.setter(Builder::trainingEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingEndTime").build()}).build();
    private static final SdkField<EntityRecognizerInputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputDataConfig").getter(EntityRecognizerProperties.getter(EntityRecognizerProperties::inputDataConfig)).setter(EntityRecognizerProperties.setter(Builder::inputDataConfig)).constructor(EntityRecognizerInputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()}).build();
    private static final SdkField<EntityRecognizerMetadata> RECOGNIZER_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecognizerMetadata").getter(EntityRecognizerProperties.getter(EntityRecognizerProperties::recognizerMetadata)).setter(EntityRecognizerProperties.setter(Builder::recognizerMetadata)).constructor(EntityRecognizerMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecognizerMetadata").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessRoleArn").getter(EntityRecognizerProperties.getter(EntityRecognizerProperties::dataAccessRoleArn)).setter(EntityRecognizerProperties.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<String> VOLUME_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeKmsKeyId").getter(EntityRecognizerProperties.getter(EntityRecognizerProperties::volumeKmsKeyId)).setter(EntityRecognizerProperties.setter(Builder::volumeKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeKmsKeyId").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(EntityRecognizerProperties.getter(EntityRecognizerProperties::vpcConfig)).setter(EntityRecognizerProperties.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<String> MODEL_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelKmsKeyId").getter(EntityRecognizerProperties.getter(EntityRecognizerProperties::modelKmsKeyId)).setter(EntityRecognizerProperties.setter(Builder::modelKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelKmsKeyId").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionName").getter(EntityRecognizerProperties.getter(EntityRecognizerProperties::versionName)).setter(EntityRecognizerProperties.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()}).build();
    private static final SdkField<String> SOURCE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceModelArn").getter(EntityRecognizerProperties.getter(EntityRecognizerProperties::sourceModelArn)).setter(EntityRecognizerProperties.setter(Builder::sourceModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceModelArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_RECOGNIZER_ARN_FIELD, LANGUAGE_CODE_FIELD, STATUS_FIELD, MESSAGE_FIELD, SUBMIT_TIME_FIELD, END_TIME_FIELD, TRAINING_START_TIME_FIELD, TRAINING_END_TIME_FIELD, INPUT_DATA_CONFIG_FIELD, RECOGNIZER_METADATA_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, VOLUME_KMS_KEY_ID_FIELD, VPC_CONFIG_FIELD, MODEL_KMS_KEY_ID_FIELD, VERSION_NAME_FIELD, SOURCE_MODEL_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String entityRecognizerArn;
    private final String languageCode;
    private final String status;
    private final String message;
    private final Instant submitTime;
    private final Instant endTime;
    private final Instant trainingStartTime;
    private final Instant trainingEndTime;
    private final EntityRecognizerInputDataConfig inputDataConfig;
    private final EntityRecognizerMetadata recognizerMetadata;
    private final String dataAccessRoleArn;
    private final String volumeKmsKeyId;
    private final VpcConfig vpcConfig;
    private final String modelKmsKeyId;
    private final String versionName;
    private final String sourceModelArn;

    private EntityRecognizerProperties(BuilderImpl builder) {
        this.entityRecognizerArn = builder.entityRecognizerArn;
        this.languageCode = builder.languageCode;
        this.status = builder.status;
        this.message = builder.message;
        this.submitTime = builder.submitTime;
        this.endTime = builder.endTime;
        this.trainingStartTime = builder.trainingStartTime;
        this.trainingEndTime = builder.trainingEndTime;
        this.inputDataConfig = builder.inputDataConfig;
        this.recognizerMetadata = builder.recognizerMetadata;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.volumeKmsKeyId = builder.volumeKmsKeyId;
        this.vpcConfig = builder.vpcConfig;
        this.modelKmsKeyId = builder.modelKmsKeyId;
        this.versionName = builder.versionName;
        this.sourceModelArn = builder.sourceModelArn;
    }

    public final String entityRecognizerArn() {
        return this.entityRecognizerArn;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final ModelStatus status() {
        return ModelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String message() {
        return this.message;
    }

    public final Instant submitTime() {
        return this.submitTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Instant trainingStartTime() {
        return this.trainingStartTime;
    }

    public final Instant trainingEndTime() {
        return this.trainingEndTime;
    }

    public final EntityRecognizerInputDataConfig inputDataConfig() {
        return this.inputDataConfig;
    }

    public final EntityRecognizerMetadata recognizerMetadata() {
        return this.recognizerMetadata;
    }

    public final String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public final String volumeKmsKeyId() {
        return this.volumeKmsKeyId;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final String modelKmsKeyId() {
        return this.modelKmsKeyId;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final String sourceModelArn() {
        return this.sourceModelArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityRecognizerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.recognizerMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceModelArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityRecognizerProperties)) {
            return false;
        }
        EntityRecognizerProperties other = (EntityRecognizerProperties)obj;
        return Objects.equals(this.entityRecognizerArn(), other.entityRecognizerArn()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.submitTime(), other.submitTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.trainingStartTime(), other.trainingStartTime()) && Objects.equals(this.trainingEndTime(), other.trainingEndTime()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.recognizerMetadata(), other.recognizerMetadata()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.volumeKmsKeyId(), other.volumeKmsKeyId()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.modelKmsKeyId(), other.modelKmsKeyId()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.sourceModelArn(), other.sourceModelArn());
    }

    public final String toString() {
        return ToString.builder((String)"EntityRecognizerProperties").add("EntityRecognizerArn", (Object)this.entityRecognizerArn()).add("LanguageCode", (Object)this.languageCodeAsString()).add("Status", (Object)this.statusAsString()).add("Message", (Object)this.message()).add("SubmitTime", (Object)this.submitTime()).add("EndTime", (Object)this.endTime()).add("TrainingStartTime", (Object)this.trainingStartTime()).add("TrainingEndTime", (Object)this.trainingEndTime()).add("InputDataConfig", (Object)this.inputDataConfig()).add("RecognizerMetadata", (Object)(this.recognizerMetadata() == null ? null : "*** Sensitive Data Redacted ***")).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("VolumeKmsKeyId", (Object)this.volumeKmsKeyId()).add("VpcConfig", (Object)this.vpcConfig()).add("ModelKmsKeyId", (Object)this.modelKmsKeyId()).add("VersionName", (Object)this.versionName()).add("SourceModelArn", (Object)this.sourceModelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityRecognizerArn": {
                return Optional.ofNullable(clazz.cast(this.entityRecognizerArn()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "SubmitTime": {
                return Optional.ofNullable(clazz.cast(this.submitTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "TrainingStartTime": {
                return Optional.ofNullable(clazz.cast(this.trainingStartTime()));
            }
            case "TrainingEndTime": {
                return Optional.ofNullable(clazz.cast(this.trainingEndTime()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "RecognizerMetadata": {
                return Optional.ofNullable(clazz.cast(this.recognizerMetadata()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "VolumeKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.volumeKmsKeyId()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "ModelKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.modelKmsKeyId()));
            }
            case "VersionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "SourceModelArn": {
                return Optional.ofNullable(clazz.cast(this.sourceModelArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityRecognizerProperties, T> g) {
        return obj -> g.apply((EntityRecognizerProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entityRecognizerArn;
        private String languageCode;
        private String status;
        private String message;
        private Instant submitTime;
        private Instant endTime;
        private Instant trainingStartTime;
        private Instant trainingEndTime;
        private EntityRecognizerInputDataConfig inputDataConfig;
        private EntityRecognizerMetadata recognizerMetadata;
        private String dataAccessRoleArn;
        private String volumeKmsKeyId;
        private VpcConfig vpcConfig;
        private String modelKmsKeyId;
        private String versionName;
        private String sourceModelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityRecognizerProperties model) {
            this.entityRecognizerArn(model.entityRecognizerArn);
            this.languageCode(model.languageCode);
            this.status(model.status);
            this.message(model.message);
            this.submitTime(model.submitTime);
            this.endTime(model.endTime);
            this.trainingStartTime(model.trainingStartTime);
            this.trainingEndTime(model.trainingEndTime);
            this.inputDataConfig(model.inputDataConfig);
            this.recognizerMetadata(model.recognizerMetadata);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.volumeKmsKeyId(model.volumeKmsKeyId);
            this.vpcConfig(model.vpcConfig);
            this.modelKmsKeyId(model.modelKmsKeyId);
            this.versionName(model.versionName);
            this.sourceModelArn(model.sourceModelArn);
        }

        public final String getEntityRecognizerArn() {
            return this.entityRecognizerArn;
        }

        public final void setEntityRecognizerArn(String entityRecognizerArn) {
            this.entityRecognizerArn = entityRecognizerArn;
        }

        @Override
        @Transient
        public final Builder entityRecognizerArn(String entityRecognizerArn) {
            this.entityRecognizerArn = entityRecognizerArn;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        @Transient
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        @Transient
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getSubmitTime() {
            return this.submitTime;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        @Override
        @Transient
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getTrainingStartTime() {
            return this.trainingStartTime;
        }

        public final void setTrainingStartTime(Instant trainingStartTime) {
            this.trainingStartTime = trainingStartTime;
        }

        @Override
        @Transient
        public final Builder trainingStartTime(Instant trainingStartTime) {
            this.trainingStartTime = trainingStartTime;
            return this;
        }

        public final Instant getTrainingEndTime() {
            return this.trainingEndTime;
        }

        public final void setTrainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
        }

        @Override
        @Transient
        public final Builder trainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
            return this;
        }

        public final EntityRecognizerInputDataConfig.Builder getInputDataConfig() {
            return this.inputDataConfig != null ? this.inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(EntityRecognizerInputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder inputDataConfig(EntityRecognizerInputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final EntityRecognizerMetadata.Builder getRecognizerMetadata() {
            return this.recognizerMetadata != null ? this.recognizerMetadata.toBuilder() : null;
        }

        public final void setRecognizerMetadata(EntityRecognizerMetadata.BuilderImpl recognizerMetadata) {
            this.recognizerMetadata = recognizerMetadata != null ? recognizerMetadata.build() : null;
        }

        @Override
        @Transient
        public final Builder recognizerMetadata(EntityRecognizerMetadata recognizerMetadata) {
            this.recognizerMetadata = recognizerMetadata;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        @Transient
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final String getVolumeKmsKeyId() {
            return this.volumeKmsKeyId;
        }

        public final void setVolumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
        }

        @Override
        @Transient
        public final Builder volumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final String getModelKmsKeyId() {
            return this.modelKmsKeyId;
        }

        public final void setModelKmsKeyId(String modelKmsKeyId) {
            this.modelKmsKeyId = modelKmsKeyId;
        }

        @Override
        @Transient
        public final Builder modelKmsKeyId(String modelKmsKeyId) {
            this.modelKmsKeyId = modelKmsKeyId;
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        @Transient
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getSourceModelArn() {
            return this.sourceModelArn;
        }

        public final void setSourceModelArn(String sourceModelArn) {
            this.sourceModelArn = sourceModelArn;
        }

        @Override
        @Transient
        public final Builder sourceModelArn(String sourceModelArn) {
            this.sourceModelArn = sourceModelArn;
            return this;
        }

        public EntityRecognizerProperties build() {
            return new EntityRecognizerProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityRecognizerProperties> {
        public Builder entityRecognizerArn(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder status(String var1);

        public Builder status(ModelStatus var1);

        public Builder message(String var1);

        public Builder submitTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder trainingStartTime(Instant var1);

        public Builder trainingEndTime(Instant var1);

        public Builder inputDataConfig(EntityRecognizerInputDataConfig var1);

        default public Builder inputDataConfig(Consumer<EntityRecognizerInputDataConfig.Builder> inputDataConfig) {
            return this.inputDataConfig((EntityRecognizerInputDataConfig)((EntityRecognizerInputDataConfig.Builder)EntityRecognizerInputDataConfig.builder().applyMutation(inputDataConfig)).build());
        }

        public Builder recognizerMetadata(EntityRecognizerMetadata var1);

        default public Builder recognizerMetadata(Consumer<EntityRecognizerMetadata.Builder> recognizerMetadata) {
            return this.recognizerMetadata((EntityRecognizerMetadata)((EntityRecognizerMetadata.Builder)EntityRecognizerMetadata.builder().applyMutation(recognizerMetadata)).build());
        }

        public Builder dataAccessRoleArn(String var1);

        public Builder volumeKmsKeyId(String var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder modelKmsKeyId(String var1);

        public Builder versionName(String var1);

        public Builder sourceModelArn(String var1);
    }
}

