/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.InputDataConfig;
import software.amazon.awssdk.services.comprehend.model.JobStatus;
import software.amazon.awssdk.services.comprehend.model.LanguageCode;
import software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMode;
import software.amazon.awssdk.services.comprehend.model.PiiOutputDataConfig;
import software.amazon.awssdk.services.comprehend.model.RedactionConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PiiEntitiesDetectionJobProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PiiEntitiesDetectionJobProperties> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(PiiEntitiesDetectionJobProperties.getter(PiiEntitiesDetectionJobProperties::jobId)).setter(PiiEntitiesDetectionJobProperties.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobArn").getter(PiiEntitiesDetectionJobProperties.getter(PiiEntitiesDetectionJobProperties::jobArn)).setter(PiiEntitiesDetectionJobProperties.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobArn").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(PiiEntitiesDetectionJobProperties.getter(PiiEntitiesDetectionJobProperties::jobName)).setter(PiiEntitiesDetectionJobProperties.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(PiiEntitiesDetectionJobProperties.getter(PiiEntitiesDetectionJobProperties::jobStatusAsString)).setter(PiiEntitiesDetectionJobProperties.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(PiiEntitiesDetectionJobProperties.getter(PiiEntitiesDetectionJobProperties::message)).setter(PiiEntitiesDetectionJobProperties.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Instant> SUBMIT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubmitTime").getter(PiiEntitiesDetectionJobProperties.getter(PiiEntitiesDetectionJobProperties::submitTime)).setter(PiiEntitiesDetectionJobProperties.setter(Builder::submitTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(PiiEntitiesDetectionJobProperties.getter(PiiEntitiesDetectionJobProperties::endTime)).setter(PiiEntitiesDetectionJobProperties.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputDataConfig").getter(PiiEntitiesDetectionJobProperties.getter(PiiEntitiesDetectionJobProperties::inputDataConfig)).setter(PiiEntitiesDetectionJobProperties.setter(Builder::inputDataConfig)).constructor(InputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()}).build();
    private static final SdkField<PiiOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputDataConfig").getter(PiiEntitiesDetectionJobProperties.getter(PiiEntitiesDetectionJobProperties::outputDataConfig)).setter(PiiEntitiesDetectionJobProperties.setter(Builder::outputDataConfig)).constructor(PiiOutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final SdkField<RedactionConfig> REDACTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RedactionConfig").getter(PiiEntitiesDetectionJobProperties.getter(PiiEntitiesDetectionJobProperties::redactionConfig)).setter(PiiEntitiesDetectionJobProperties.setter(Builder::redactionConfig)).constructor(RedactionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedactionConfig").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(PiiEntitiesDetectionJobProperties.getter(PiiEntitiesDetectionJobProperties::languageCodeAsString)).setter(PiiEntitiesDetectionJobProperties.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessRoleArn").getter(PiiEntitiesDetectionJobProperties.getter(PiiEntitiesDetectionJobProperties::dataAccessRoleArn)).setter(PiiEntitiesDetectionJobProperties.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(PiiEntitiesDetectionJobProperties.getter(PiiEntitiesDetectionJobProperties::modeAsString)).setter(PiiEntitiesDetectionJobProperties.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_ARN_FIELD, JOB_NAME_FIELD, JOB_STATUS_FIELD, MESSAGE_FIELD, SUBMIT_TIME_FIELD, END_TIME_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, REDACTION_CONFIG_FIELD, LANGUAGE_CODE_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final String jobArn;
    private final String jobName;
    private final String jobStatus;
    private final String message;
    private final Instant submitTime;
    private final Instant endTime;
    private final InputDataConfig inputDataConfig;
    private final PiiOutputDataConfig outputDataConfig;
    private final RedactionConfig redactionConfig;
    private final String languageCode;
    private final String dataAccessRoleArn;
    private final String mode;

    private PiiEntitiesDetectionJobProperties(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobArn = builder.jobArn;
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
        this.message = builder.message;
        this.submitTime = builder.submitTime;
        this.endTime = builder.endTime;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.redactionConfig = builder.redactionConfig;
        this.languageCode = builder.languageCode;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.mode = builder.mode;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final String message() {
        return this.message;
    }

    public final Instant submitTime() {
        return this.submitTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final InputDataConfig inputDataConfig() {
        return this.inputDataConfig;
    }

    public final PiiOutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public final RedactionConfig redactionConfig() {
        return this.redactionConfig;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public final PiiEntitiesDetectionMode mode() {
        return PiiEntitiesDetectionMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.redactionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PiiEntitiesDetectionJobProperties)) {
            return false;
        }
        PiiEntitiesDetectionJobProperties other = (PiiEntitiesDetectionJobProperties)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.submitTime(), other.submitTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.redactionConfig(), other.redactionConfig()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.modeAsString(), other.modeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PiiEntitiesDetectionJobProperties").add("JobId", (Object)this.jobId()).add("JobArn", (Object)this.jobArn()).add("JobName", (Object)this.jobName()).add("JobStatus", (Object)this.jobStatusAsString()).add("Message", (Object)this.message()).add("SubmitTime", (Object)this.submitTime()).add("EndTime", (Object)this.endTime()).add("InputDataConfig", (Object)this.inputDataConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("RedactionConfig", (Object)this.redactionConfig()).add("LanguageCode", (Object)this.languageCodeAsString()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("Mode", (Object)this.modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "JobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "SubmitTime": {
                return Optional.ofNullable(clazz.cast(this.submitTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "RedactionConfig": {
                return Optional.ofNullable(clazz.cast(this.redactionConfig()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PiiEntitiesDetectionJobProperties, T> g) {
        return obj -> g.apply((PiiEntitiesDetectionJobProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String jobArn;
        private String jobName;
        private String jobStatus;
        private String message;
        private Instant submitTime;
        private Instant endTime;
        private InputDataConfig inputDataConfig;
        private PiiOutputDataConfig outputDataConfig;
        private RedactionConfig redactionConfig;
        private String languageCode;
        private String dataAccessRoleArn;
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(PiiEntitiesDetectionJobProperties model) {
            this.jobId(model.jobId);
            this.jobArn(model.jobArn);
            this.jobName(model.jobName);
            this.jobStatus(model.jobStatus);
            this.message(model.message);
            this.submitTime(model.submitTime);
            this.endTime(model.endTime);
            this.inputDataConfig(model.inputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.redactionConfig(model.redactionConfig);
            this.languageCode(model.languageCode);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.mode(model.mode);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        @Transient
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        @Transient
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        @Transient
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getSubmitTime() {
            return this.submitTime;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        @Override
        @Transient
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return this.inputDataConfig != null ? this.inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final PiiOutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(PiiOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder outputDataConfig(PiiOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final RedactionConfig.Builder getRedactionConfig() {
            return this.redactionConfig != null ? this.redactionConfig.toBuilder() : null;
        }

        public final void setRedactionConfig(RedactionConfig.BuilderImpl redactionConfig) {
            this.redactionConfig = redactionConfig != null ? redactionConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder redactionConfig(RedactionConfig redactionConfig) {
            this.redactionConfig = redactionConfig;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        @Transient
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        @Transient
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        @Transient
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        @Transient
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        @Transient
        public final Builder mode(PiiEntitiesDetectionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public PiiEntitiesDetectionJobProperties build() {
            return new PiiEntitiesDetectionJobProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PiiEntitiesDetectionJobProperties> {
        public Builder jobId(String var1);

        public Builder jobArn(String var1);

        public Builder jobName(String var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder message(String var1);

        public Builder submitTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder inputDataConfig(InputDataConfig var1);

        default public Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return this.inputDataConfig((InputDataConfig)((InputDataConfig.Builder)InputDataConfig.builder().applyMutation(inputDataConfig)).build());
        }

        public Builder outputDataConfig(PiiOutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<PiiOutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((PiiOutputDataConfig)((PiiOutputDataConfig.Builder)PiiOutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder redactionConfig(RedactionConfig var1);

        default public Builder redactionConfig(Consumer<RedactionConfig.Builder> redactionConfig) {
            return this.redactionConfig((RedactionConfig)((RedactionConfig.Builder)RedactionConfig.builder().applyMutation(redactionConfig)).build());
        }

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder dataAccessRoleArn(String var1);

        public Builder mode(String var1);

        public Builder mode(PiiEntitiesDetectionMode var1);
    }
}

