/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDocumentClassifierRequest extends ComprehendRequest implements
        ToCopyableBuilder<CreateDocumentClassifierRequest.Builder, CreateDocumentClassifierRequest> {
    private static final SdkField<String> DOCUMENT_CLASSIFIER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentClassifierName").getter(getter(CreateDocumentClassifierRequest::documentClassifierName))
            .setter(setter(Builder::documentClassifierName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentClassifierName").build())
            .build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(CreateDocumentClassifierRequest::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDocumentClassifierRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DocumentClassifierInputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField
            .<DocumentClassifierInputDataConfig> builder(MarshallingType.SDK_POJO).memberName("InputDataConfig")
            .getter(getter(CreateDocumentClassifierRequest::inputDataConfig)).setter(setter(Builder::inputDataConfig))
            .constructor(DocumentClassifierInputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()).build();

    private static final SdkField<DocumentClassifierOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<DocumentClassifierOutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("OutputDataConfig")
            .getter(getter(CreateDocumentClassifierRequest::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(DocumentClassifierOutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateDocumentClassifierRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(CreateDocumentClassifierRequest::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> VOLUME_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeKmsKeyId").getter(getter(CreateDocumentClassifierRequest::volumeKmsKeyId))
            .setter(setter(Builder::volumeKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeKmsKeyId").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(CreateDocumentClassifierRequest::vpcConfig))
            .setter(setter(Builder::vpcConfig)).constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(CreateDocumentClassifierRequest::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DOCUMENT_CLASSIFIER_NAME_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, TAGS_FIELD, INPUT_DATA_CONFIG_FIELD,
            OUTPUT_DATA_CONFIG_FIELD, CLIENT_REQUEST_TOKEN_FIELD, LANGUAGE_CODE_FIELD, VOLUME_KMS_KEY_ID_FIELD, VPC_CONFIG_FIELD,
            MODE_FIELD));

    private final String documentClassifierName;

    private final String dataAccessRoleArn;

    private final List<Tag> tags;

    private final DocumentClassifierInputDataConfig inputDataConfig;

    private final DocumentClassifierOutputDataConfig outputDataConfig;

    private final String clientRequestToken;

    private final String languageCode;

    private final String volumeKmsKeyId;

    private final VpcConfig vpcConfig;

    private final String mode;

    private CreateDocumentClassifierRequest(BuilderImpl builder) {
        super(builder);
        this.documentClassifierName = builder.documentClassifierName;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.tags = builder.tags;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.clientRequestToken = builder.clientRequestToken;
        this.languageCode = builder.languageCode;
        this.volumeKmsKeyId = builder.volumeKmsKeyId;
        this.vpcConfig = builder.vpcConfig;
        this.mode = builder.mode;
    }

    /**
     * <p>
     * The name of the document classifier.
     * </p>
     * 
     * @return The name of the document classifier.
     */
    public final String documentClassifierName() {
        return documentClassifierName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon Comprehend read
     * access to your input data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon
     *         Comprehend read access to your input data.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to be associated with the document classifier being created. A tag is a key-value pair that adds as a
     * metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a
     * resource to indicate its use by the sales department.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tags to be associated with the document classifier being created. A tag is a key-value pair that adds as
     *         a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be
     *         added to a resource to indicate its use by the sales department.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies the format and location of the input data for the job.
     * </p>
     * 
     * @return Specifies the format and location of the input data for the job.
     */
    public final DocumentClassifierInputDataConfig inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * Enables the addition of output results configuration parameters for custom classifier jobs.
     * </p>
     * 
     * @return Enables the addition of output results configuration parameters for custom classifier jobs.
     */
    public final DocumentClassifierOutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.
     * </p>
     * 
     * @return A unique identifier for the request. If you don't set the client request token, Amazon Comprehend
     *         generates one.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The language of the input documents. You can specify any of the following languages supported by Amazon
     * Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt").
     * All documents must be in the same language.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language of the input documents. You can specify any of the following languages supported by Amazon
     *         Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese
     *         ("pt"). All documents must be in the same language.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language of the input documents. You can specify any of the following languages supported by Amazon
     * Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt").
     * All documents must be in the same language.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language of the input documents. You can specify any of the following languages supported by Amazon
     *         Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese
     *         ("pt"). All documents must be in the same language.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume
     * attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the
     * following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Resource Name (ARN) of a KMS Key:
     * <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the
     *         storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId
     *         can be either of the following formats:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Resource Name (ARN) of a KMS Key:
     *         <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     *         </p>
     *         </li>
     */
    public final String volumeKmsKeyId() {
        return volumeKmsKeyId;
    }

    /**
     * <p>
     * Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are
     * using for your custom classifier. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>.
     * </p>
     * 
     * @return Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you
     *         are using for your custom classifier. For more information, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * Indicates the mode in which the classifier will be trained. The classifier can be trained in multi-class mode,
     * which identifies one and only one class for each document, or multi-label mode, which identifies one or more
     * labels for each document. In multi-label mode, multiple labels for an individual document are separated by a
     * delimiter. The default delimiter between labels is a pipe (|).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link DocumentClassifierMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Indicates the mode in which the classifier will be trained. The classifier can be trained in multi-class
     *         mode, which identifies one and only one class for each document, or multi-label mode, which identifies
     *         one or more labels for each document. In multi-label mode, multiple labels for an individual document are
     *         separated by a delimiter. The default delimiter between labels is a pipe (|).
     * @see DocumentClassifierMode
     */
    public final DocumentClassifierMode mode() {
        return DocumentClassifierMode.fromValue(mode);
    }

    /**
     * <p>
     * Indicates the mode in which the classifier will be trained. The classifier can be trained in multi-class mode,
     * which identifies one and only one class for each document, or multi-label mode, which identifies one or more
     * labels for each document. In multi-label mode, multiple labels for an individual document are separated by a
     * delimiter. The default delimiter between labels is a pipe (|).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link DocumentClassifierMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Indicates the mode in which the classifier will be trained. The classifier can be trained in multi-class
     *         mode, which identifies one and only one class for each document, or multi-label mode, which identifies
     *         one or more labels for each document. In multi-label mode, multiple labels for an individual document are
     *         separated by a delimiter. The default delimiter between labels is a pipe (|).
     * @see DocumentClassifierMode
     */
    public final String modeAsString() {
        return mode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(documentClassifierName());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(volumeKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDocumentClassifierRequest)) {
            return false;
        }
        CreateDocumentClassifierRequest other = (CreateDocumentClassifierRequest) obj;
        return Objects.equals(documentClassifierName(), other.documentClassifierName())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(volumeKmsKeyId(), other.volumeKmsKeyId()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(modeAsString(), other.modeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDocumentClassifierRequest").add("DocumentClassifierName", documentClassifierName())
                .add("DataAccessRoleArn", dataAccessRoleArn()).add("Tags", hasTags() ? tags() : null)
                .add("InputDataConfig", inputDataConfig()).add("OutputDataConfig", outputDataConfig())
                .add("ClientRequestToken", clientRequestToken()).add("LanguageCode", languageCodeAsString())
                .add("VolumeKmsKeyId", volumeKmsKeyId()).add("VpcConfig", vpcConfig()).add("Mode", modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentClassifierName":
            return Optional.ofNullable(clazz.cast(documentClassifierName()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "OutputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "VolumeKmsKeyId":
            return Optional.ofNullable(clazz.cast(volumeKmsKeyId()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDocumentClassifierRequest, T> g) {
        return obj -> g.apply((CreateDocumentClassifierRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDocumentClassifierRequest> {
        /**
         * <p>
         * The name of the document classifier.
         * </p>
         * 
         * @param documentClassifierName
         *        The name of the document classifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentClassifierName(String documentClassifierName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon Comprehend
         * read access to your input data.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon
         *        Comprehend read access to your input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * Tags to be associated with the document classifier being created. A tag is a key-value pair that adds as a
         * metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added
         * to a resource to indicate its use by the sales department.
         * </p>
         * 
         * @param tags
         *        Tags to be associated with the document classifier being created. A tag is a key-value pair that adds
         *        as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key
         *        might be added to a resource to indicate its use by the sales department.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags to be associated with the document classifier being created. A tag is a key-value pair that adds as a
         * metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added
         * to a resource to indicate its use by the sales department.
         * </p>
         * 
         * @param tags
         *        Tags to be associated with the document classifier being created. A tag is a key-value pair that adds
         *        as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key
         *        might be added to a resource to indicate its use by the sales department.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags to be associated with the document classifier being created. A tag is a key-value pair that adds as a
         * metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added
         * to a resource to indicate its use by the sales department.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Specifies the format and location of the input data for the job.
         * </p>
         * 
         * @param inputDataConfig
         *        Specifies the format and location of the input data for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(DocumentClassifierInputDataConfig inputDataConfig);

        /**
         * <p>
         * Specifies the format and location of the input data for the job.
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentClassifierInputDataConfig.Builder}
         * avoiding the need to create one manually via {@link DocumentClassifierInputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentClassifierInputDataConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #inputDataConfig(DocumentClassifierInputDataConfig)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link DocumentClassifierInputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(DocumentClassifierInputDataConfig)
         */
        default Builder inputDataConfig(Consumer<DocumentClassifierInputDataConfig.Builder> inputDataConfig) {
            return inputDataConfig(DocumentClassifierInputDataConfig.builder().applyMutation(inputDataConfig).build());
        }

        /**
         * <p>
         * Enables the addition of output results configuration parameters for custom classifier jobs.
         * </p>
         * 
         * @param outputDataConfig
         *        Enables the addition of output results configuration parameters for custom classifier jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(DocumentClassifierOutputDataConfig outputDataConfig);

        /**
         * <p>
         * Enables the addition of output results configuration parameters for custom classifier jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentClassifierOutputDataConfig.Builder}
         * avoiding the need to create one manually via {@link DocumentClassifierOutputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentClassifierOutputDataConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #outputDataConfig(DocumentClassifierOutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link DocumentClassifierOutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(DocumentClassifierOutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<DocumentClassifierOutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(DocumentClassifierOutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates
         * one.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique identifier for the request. If you don't set the client request token, Amazon Comprehend
         *        generates one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The language of the input documents. You can specify any of the following languages supported by Amazon
         * Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese
         * ("pt"). All documents must be in the same language.
         * </p>
         * 
         * @param languageCode
         *        The language of the input documents. You can specify any of the following languages supported by
         *        Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or
         *        Portuguese ("pt"). All documents must be in the same language.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language of the input documents. You can specify any of the following languages supported by Amazon
         * Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese
         * ("pt"). All documents must be in the same language.
         * </p>
         * 
         * @param languageCode
         *        The language of the input documents. You can specify any of the following languages supported by
         *        Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or
         *        Portuguese ("pt"). All documents must be in the same language.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage
         * volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either
         * of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Resource Name (ARN) of a KMS Key:
         * <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param volumeKmsKeyId
         *        ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the
         *        storage volume attached to the ML compute instance(s) that process the analysis job. The
         *        VolumeKmsKeyId can be either of the following formats:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Resource Name (ARN) of a KMS Key:
         *        <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeKmsKeyId(String volumeKmsKeyId);

        /**
         * <p>
         * Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are
         * using for your custom classifier. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>.
         * </p>
         * 
         * @param vpcConfig
         *        Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources
         *        you are using for your custom classifier. For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are
         * using for your custom classifier. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfig.Builder} avoiding the need to create
         * one manually via {@link VpcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * Indicates the mode in which the classifier will be trained. The classifier can be trained in multi-class
         * mode, which identifies one and only one class for each document, or multi-label mode, which identifies one or
         * more labels for each document. In multi-label mode, multiple labels for an individual document are separated
         * by a delimiter. The default delimiter between labels is a pipe (|).
         * </p>
         * 
         * @param mode
         *        Indicates the mode in which the classifier will be trained. The classifier can be trained in
         *        multi-class mode, which identifies one and only one class for each document, or multi-label mode,
         *        which identifies one or more labels for each document. In multi-label mode, multiple labels for an
         *        individual document are separated by a delimiter. The default delimiter between labels is a pipe (|).
         * @see DocumentClassifierMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentClassifierMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * Indicates the mode in which the classifier will be trained. The classifier can be trained in multi-class
         * mode, which identifies one and only one class for each document, or multi-label mode, which identifies one or
         * more labels for each document. In multi-label mode, multiple labels for an individual document are separated
         * by a delimiter. The default delimiter between labels is a pipe (|).
         * </p>
         * 
         * @param mode
         *        Indicates the mode in which the classifier will be trained. The classifier can be trained in
         *        multi-class mode, which identifies one and only one class for each document, or multi-label mode,
         *        which identifies one or more labels for each document. In multi-label mode, multiple labels for an
         *        individual document are separated by a delimiter. The default delimiter between labels is a pipe (|).
         * @see DocumentClassifierMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentClassifierMode
         */
        Builder mode(DocumentClassifierMode mode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComprehendRequest.BuilderImpl implements Builder {
        private String documentClassifierName;

        private String dataAccessRoleArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private DocumentClassifierInputDataConfig inputDataConfig;

        private DocumentClassifierOutputDataConfig outputDataConfig;

        private String clientRequestToken;

        private String languageCode;

        private String volumeKmsKeyId;

        private VpcConfig vpcConfig;

        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDocumentClassifierRequest model) {
            super(model);
            documentClassifierName(model.documentClassifierName);
            dataAccessRoleArn(model.dataAccessRoleArn);
            tags(model.tags);
            inputDataConfig(model.inputDataConfig);
            outputDataConfig(model.outputDataConfig);
            clientRequestToken(model.clientRequestToken);
            languageCode(model.languageCode);
            volumeKmsKeyId(model.volumeKmsKeyId);
            vpcConfig(model.vpcConfig);
            mode(model.mode);
        }

        public final String getDocumentClassifierName() {
            return documentClassifierName;
        }

        @Override
        public final Builder documentClassifierName(String documentClassifierName) {
            this.documentClassifierName = documentClassifierName;
            return this;
        }

        public final void setDocumentClassifierName(String documentClassifierName) {
            this.documentClassifierName = documentClassifierName;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final DocumentClassifierInputDataConfig.Builder getInputDataConfig() {
            return inputDataConfig != null ? inputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder inputDataConfig(DocumentClassifierInputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final void setInputDataConfig(DocumentClassifierInputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        public final DocumentClassifierOutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputDataConfig(DocumentClassifierOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final void setOutputDataConfig(DocumentClassifierOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getVolumeKmsKeyId() {
            return volumeKmsKeyId;
        }

        @Override
        public final Builder volumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
            return this;
        }

        public final void setVolumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final String getMode() {
            return mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(DocumentClassifierMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDocumentClassifierRequest build() {
            return new CreateDocumentClassifierRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
