/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a work in the input text that was recognized and assigned a part of speech. There is one syntax token
 * record for each word in the source text.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SyntaxToken implements SdkPojo, Serializable, ToCopyableBuilder<SyntaxToken.Builder, SyntaxToken> {
    private static final SdkField<Integer> TOKEN_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TokenId").getter(getter(SyntaxToken::tokenId)).setter(setter(Builder::tokenId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenId").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(SyntaxToken::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BeginOffset").getter(getter(SyntaxToken::beginOffset)).setter(setter(Builder::beginOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()).build();

    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndOffset").getter(getter(SyntaxToken::endOffset)).setter(setter(Builder::endOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()).build();

    private static final SdkField<PartOfSpeechTag> PART_OF_SPEECH_FIELD = SdkField
            .<PartOfSpeechTag> builder(MarshallingType.SDK_POJO).memberName("PartOfSpeech")
            .getter(getter(SyntaxToken::partOfSpeech)).setter(setter(Builder::partOfSpeech))
            .constructor(PartOfSpeechTag::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartOfSpeech").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_ID_FIELD, TEXT_FIELD,
            BEGIN_OFFSET_FIELD, END_OFFSET_FIELD, PART_OF_SPEECH_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer tokenId;

    private final String text;

    private final Integer beginOffset;

    private final Integer endOffset;

    private final PartOfSpeechTag partOfSpeech;

    private SyntaxToken(BuilderImpl builder) {
        this.tokenId = builder.tokenId;
        this.text = builder.text;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.partOfSpeech = builder.partOfSpeech;
    }

    /**
     * <p>
     * A unique identifier for a token.
     * </p>
     * 
     * @return A unique identifier for a token.
     */
    public final Integer tokenId() {
        return tokenId;
    }

    /**
     * <p>
     * The word that was recognized in the source text.
     * </p>
     * 
     * @return The word that was recognized in the source text.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The zero-based offset from the beginning of the source text to the first character in the word.
     * </p>
     * 
     * @return The zero-based offset from the beginning of the source text to the first character in the word.
     */
    public final Integer beginOffset() {
        return beginOffset;
    }

    /**
     * <p>
     * The zero-based offset from the beginning of the source text to the last character in the word.
     * </p>
     * 
     * @return The zero-based offset from the beginning of the source text to the last character in the word.
     */
    public final Integer endOffset() {
        return endOffset;
    }

    /**
     * <p>
     * Provides the part of speech label and the confidence level that Amazon Comprehend has that the part of speech was
     * correctly identified. For more information, see <a>how-syntax</a>.
     * </p>
     * 
     * @return Provides the part of speech label and the confidence level that Amazon Comprehend has that the part of
     *         speech was correctly identified. For more information, see <a>how-syntax</a>.
     */
    public final PartOfSpeechTag partOfSpeech() {
        return partOfSpeech;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tokenId());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(partOfSpeech());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyntaxToken)) {
            return false;
        }
        SyntaxToken other = (SyntaxToken) obj;
        return Objects.equals(tokenId(), other.tokenId()) && Objects.equals(text(), other.text())
                && Objects.equals(beginOffset(), other.beginOffset()) && Objects.equals(endOffset(), other.endOffset())
                && Objects.equals(partOfSpeech(), other.partOfSpeech());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SyntaxToken").add("TokenId", tokenId()).add("Text", text()).add("BeginOffset", beginOffset())
                .add("EndOffset", endOffset()).add("PartOfSpeech", partOfSpeech()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TokenId":
            return Optional.ofNullable(clazz.cast(tokenId()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "BeginOffset":
            return Optional.ofNullable(clazz.cast(beginOffset()));
        case "EndOffset":
            return Optional.ofNullable(clazz.cast(endOffset()));
        case "PartOfSpeech":
            return Optional.ofNullable(clazz.cast(partOfSpeech()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SyntaxToken, T> g) {
        return obj -> g.apply((SyntaxToken) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SyntaxToken> {
        /**
         * <p>
         * A unique identifier for a token.
         * </p>
         * 
         * @param tokenId
         *        A unique identifier for a token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenId(Integer tokenId);

        /**
         * <p>
         * The word that was recognized in the source text.
         * </p>
         * 
         * @param text
         *        The word that was recognized in the source text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The zero-based offset from the beginning of the source text to the first character in the word.
         * </p>
         * 
         * @param beginOffset
         *        The zero-based offset from the beginning of the source text to the first character in the word.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffset(Integer beginOffset);

        /**
         * <p>
         * The zero-based offset from the beginning of the source text to the last character in the word.
         * </p>
         * 
         * @param endOffset
         *        The zero-based offset from the beginning of the source text to the last character in the word.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffset(Integer endOffset);

        /**
         * <p>
         * Provides the part of speech label and the confidence level that Amazon Comprehend has that the part of speech
         * was correctly identified. For more information, see <a>how-syntax</a>.
         * </p>
         * 
         * @param partOfSpeech
         *        Provides the part of speech label and the confidence level that Amazon Comprehend has that the part of
         *        speech was correctly identified. For more information, see <a>how-syntax</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partOfSpeech(PartOfSpeechTag partOfSpeech);

        /**
         * <p>
         * Provides the part of speech label and the confidence level that Amazon Comprehend has that the part of speech
         * was correctly identified. For more information, see <a>how-syntax</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link PartOfSpeechTag.Builder} avoiding the need to
         * create one manually via {@link PartOfSpeechTag#builder()}.
         *
         * When the {@link Consumer} completes, {@link PartOfSpeechTag.Builder#build()} is called immediately and its
         * result is passed to {@link #partOfSpeech(PartOfSpeechTag)}.
         * 
         * @param partOfSpeech
         *        a consumer that will call methods on {@link PartOfSpeechTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partOfSpeech(PartOfSpeechTag)
         */
        default Builder partOfSpeech(Consumer<PartOfSpeechTag.Builder> partOfSpeech) {
            return partOfSpeech(PartOfSpeechTag.builder().applyMutation(partOfSpeech).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer tokenId;

        private String text;

        private Integer beginOffset;

        private Integer endOffset;

        private PartOfSpeechTag partOfSpeech;

        private BuilderImpl() {
        }

        private BuilderImpl(SyntaxToken model) {
            tokenId(model.tokenId);
            text(model.text);
            beginOffset(model.beginOffset);
            endOffset(model.endOffset);
            partOfSpeech(model.partOfSpeech);
        }

        public final Integer getTokenId() {
            return tokenId;
        }

        @Override
        public final Builder tokenId(Integer tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public final void setTokenId(Integer tokenId) {
            this.tokenId = tokenId;
        }

        public final String getText() {
            return text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final Integer getBeginOffset() {
            return beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        public final Integer getEndOffset() {
            return endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        public final PartOfSpeechTag.Builder getPartOfSpeech() {
            return partOfSpeech != null ? partOfSpeech.toBuilder() : null;
        }

        @Override
        public final Builder partOfSpeech(PartOfSpeechTag partOfSpeech) {
            this.partOfSpeech = partOfSpeech;
            return this;
        }

        public final void setPartOfSpeech(PartOfSpeechTag.BuilderImpl partOfSpeech) {
            this.partOfSpeech = partOfSpeech != null ? partOfSpeech.build() : null;
        }

        @Override
        public SyntaxToken build() {
            return new SyntaxToken(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
