/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.EndpointProperties;
import software.amazon.awssdk.services.comprehend.model.EndpointPropertiesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEndpointsResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ListEndpointsResponse> {
    private static final SdkField<List<EndpointProperties>> ENDPOINT_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndpointPropertiesList").getter(ListEndpointsResponse.getter(ListEndpointsResponse::endpointPropertiesList)).setter(ListEndpointsResponse.setter(Builder::endpointPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEndpointsResponse.getter(ListEndpointsResponse::nextToken)).setter(ListEndpointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<EndpointProperties> endpointPropertiesList;
    private final String nextToken;

    private ListEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.endpointPropertiesList = builder.endpointPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEndpointPropertiesList() {
        return this.endpointPropertiesList != null && !(this.endpointPropertiesList instanceof SdkAutoConstructList);
    }

    public final List<EndpointProperties> endpointPropertiesList() {
        return this.endpointPropertiesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpointPropertiesList() ? this.endpointPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEndpointsResponse)) {
            return false;
        }
        ListEndpointsResponse other = (ListEndpointsResponse)((Object)obj);
        return this.hasEndpointPropertiesList() == other.hasEndpointPropertiesList() && Objects.equals(this.endpointPropertiesList(), other.endpointPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEndpointsResponse").add("EndpointPropertiesList", this.hasEndpointPropertiesList() ? this.endpointPropertiesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.endpointPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEndpointsResponse, T> g) {
        return obj -> g.apply((ListEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<EndpointProperties> endpointPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEndpointsResponse model) {
            super(model);
            this.endpointPropertiesList(model.endpointPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final Collection<EndpointProperties.Builder> getEndpointPropertiesList() {
            if (this.endpointPropertiesList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.endpointPropertiesList != null ? (Collection)this.endpointPropertiesList.stream().map(EndpointProperties::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endpointPropertiesList(Collection<EndpointProperties> endpointPropertiesList) {
            this.endpointPropertiesList = EndpointPropertiesListCopier.copy(endpointPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointPropertiesList(EndpointProperties ... endpointPropertiesList) {
            this.endpointPropertiesList(Arrays.asList(endpointPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointPropertiesList(Consumer<EndpointProperties.Builder> ... endpointPropertiesList) {
            this.endpointPropertiesList(Stream.of(endpointPropertiesList).map(c -> (EndpointProperties)((EndpointProperties.Builder)EndpointProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndpointPropertiesList(Collection<EndpointProperties.BuilderImpl> endpointPropertiesList) {
            this.endpointPropertiesList = EndpointPropertiesListCopier.copyFromBuilder(endpointPropertiesList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEndpointsResponse build() {
            return new ListEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEndpointsResponse> {
        public Builder endpointPropertiesList(Collection<EndpointProperties> var1);

        public Builder endpointPropertiesList(EndpointProperties ... var1);

        public Builder endpointPropertiesList(Consumer<EndpointProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

