/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.services.comprehend.model.InputDataConfig;
import software.amazon.awssdk.services.comprehend.model.LanguageCode;
import software.amazon.awssdk.services.comprehend.model.OutputDataConfig;
import software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMode;
import software.amazon.awssdk.services.comprehend.model.RedactionConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartPiiEntitiesDetectionJobRequest
extends ComprehendRequest
implements ToCopyableBuilder<Builder, StartPiiEntitiesDetectionJobRequest> {
    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartPiiEntitiesDetectionJobRequest.getter(StartPiiEntitiesDetectionJobRequest::inputDataConfig)).setter(StartPiiEntitiesDetectionJobRequest.setter(Builder::inputDataConfig)).constructor(InputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()}).build();
    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartPiiEntitiesDetectionJobRequest.getter(StartPiiEntitiesDetectionJobRequest::outputDataConfig)).setter(StartPiiEntitiesDetectionJobRequest.setter(Builder::outputDataConfig)).constructor(OutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartPiiEntitiesDetectionJobRequest.getter(StartPiiEntitiesDetectionJobRequest::modeAsString)).setter(StartPiiEntitiesDetectionJobRequest.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<RedactionConfig> REDACTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartPiiEntitiesDetectionJobRequest.getter(StartPiiEntitiesDetectionJobRequest::redactionConfig)).setter(StartPiiEntitiesDetectionJobRequest.setter(Builder::redactionConfig)).constructor(RedactionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedactionConfig").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartPiiEntitiesDetectionJobRequest.getter(StartPiiEntitiesDetectionJobRequest::dataAccessRoleArn)).setter(StartPiiEntitiesDetectionJobRequest.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartPiiEntitiesDetectionJobRequest.getter(StartPiiEntitiesDetectionJobRequest::jobName)).setter(StartPiiEntitiesDetectionJobRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartPiiEntitiesDetectionJobRequest.getter(StartPiiEntitiesDetectionJobRequest::languageCodeAsString)).setter(StartPiiEntitiesDetectionJobRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartPiiEntitiesDetectionJobRequest.getter(StartPiiEntitiesDetectionJobRequest::clientRequestToken)).setter(StartPiiEntitiesDetectionJobRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, MODE_FIELD, REDACTION_CONFIG_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, JOB_NAME_FIELD, LANGUAGE_CODE_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final InputDataConfig inputDataConfig;
    private final OutputDataConfig outputDataConfig;
    private final String mode;
    private final RedactionConfig redactionConfig;
    private final String dataAccessRoleArn;
    private final String jobName;
    private final String languageCode;
    private final String clientRequestToken;

    private StartPiiEntitiesDetectionJobRequest(BuilderImpl builder) {
        super(builder);
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.mode = builder.mode;
        this.redactionConfig = builder.redactionConfig;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.jobName = builder.jobName;
        this.languageCode = builder.languageCode;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public InputDataConfig inputDataConfig() {
        return this.inputDataConfig;
    }

    public OutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public PiiEntitiesDetectionMode mode() {
        return PiiEntitiesDetectionMode.fromValue(this.mode);
    }

    public String modeAsString() {
        return this.mode;
    }

    public RedactionConfig redactionConfig() {
        return this.redactionConfig;
    }

    public String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public String jobName() {
        return this.jobName;
    }

    public LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeAsString() {
        return this.languageCode;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.redactionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartPiiEntitiesDetectionJobRequest)) {
            return false;
        }
        StartPiiEntitiesDetectionJobRequest other = (StartPiiEntitiesDetectionJobRequest)((Object)obj);
        return Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.redactionConfig(), other.redactionConfig()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public String toString() {
        return ToString.builder((String)"StartPiiEntitiesDetectionJobRequest").add("InputDataConfig", (Object)this.inputDataConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("Mode", (Object)this.modeAsString()).add("RedactionConfig", (Object)this.redactionConfig()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("JobName", (Object)this.jobName()).add("LanguageCode", (Object)this.languageCodeAsString()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "RedactionConfig": {
                return Optional.ofNullable(clazz.cast(this.redactionConfig()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartPiiEntitiesDetectionJobRequest, T> g) {
        return obj -> g.apply((StartPiiEntitiesDetectionJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendRequest.BuilderImpl
    implements Builder {
        private InputDataConfig inputDataConfig;
        private OutputDataConfig outputDataConfig;
        private String mode;
        private RedactionConfig redactionConfig;
        private String dataAccessRoleArn;
        private String jobName;
        private String languageCode;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartPiiEntitiesDetectionJobRequest model) {
            super(model);
            this.inputDataConfig(model.inputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.mode(model.mode);
            this.redactionConfig(model.redactionConfig);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.jobName(model.jobName);
            this.languageCode(model.languageCode);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return this.inputDataConfig != null ? this.inputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        public final String getMode() {
            return this.mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(PiiEntitiesDetectionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public final RedactionConfig.Builder getRedactionConfig() {
            return this.redactionConfig != null ? this.redactionConfig.toBuilder() : null;
        }

        @Override
        public final Builder redactionConfig(RedactionConfig redactionConfig) {
            this.redactionConfig = redactionConfig;
            return this;
        }

        public final void setRedactionConfig(RedactionConfig.BuilderImpl redactionConfig) {
            this.redactionConfig = redactionConfig != null ? redactionConfig.build() : null;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartPiiEntitiesDetectionJobRequest build() {
            return new StartPiiEntitiesDetectionJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartPiiEntitiesDetectionJobRequest> {
        public Builder inputDataConfig(InputDataConfig var1);

        default public Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return this.inputDataConfig((InputDataConfig)((InputDataConfig.Builder)InputDataConfig.builder().applyMutation(inputDataConfig)).build());
        }

        public Builder outputDataConfig(OutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((OutputDataConfig)((OutputDataConfig.Builder)OutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder mode(String var1);

        public Builder mode(PiiEntitiesDetectionMode var1);

        public Builder redactionConfig(RedactionConfig var1);

        default public Builder redactionConfig(Consumer<RedactionConfig.Builder> redactionConfig) {
            return this.redactionConfig((RedactionConfig)((RedactionConfig.Builder)RedactionConfig.builder().applyMutation(redactionConfig)).build());
        }

        public Builder dataAccessRoleArn(String var1);

        public Builder jobName(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

