/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDocumentClassificationJobsResponse extends ComprehendResponse implements
        ToCopyableBuilder<ListDocumentClassificationJobsResponse.Builder, ListDocumentClassificationJobsResponse> {
    private static final SdkField<List<DocumentClassificationJobProperties>> DOCUMENT_CLASSIFICATION_JOB_PROPERTIES_LIST_FIELD = SdkField
            .<List<DocumentClassificationJobProperties>> builder(MarshallingType.LIST)
            .getter(getter(ListDocumentClassificationJobsResponse::documentClassificationJobPropertiesList))
            .setter(setter(Builder::documentClassificationJobPropertiesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DocumentClassificationJobPropertiesList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentClassificationJobProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentClassificationJobProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDocumentClassificationJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DOCUMENT_CLASSIFICATION_JOB_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<DocumentClassificationJobProperties> documentClassificationJobPropertiesList;

    private final String nextToken;

    private ListDocumentClassificationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.documentClassificationJobPropertiesList = builder.documentClassificationJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the DocumentClassificationJobPropertiesList property was specified by the sender (it may be
     * empty), or false if the sender did not specify the value (it will be empty). For responses returned by the SDK,
     * the sender is the AWS service.
     */
    public boolean hasDocumentClassificationJobPropertiesList() {
        return documentClassificationJobPropertiesList != null
                && !(documentClassificationJobPropertiesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing the properties of each job returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDocumentClassificationJobPropertiesList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list containing the properties of each job returned.
     */
    public List<DocumentClassificationJobProperties> documentClassificationJobPropertiesList() {
        return documentClassificationJobPropertiesList;
    }

    /**
     * <p>
     * Identifies the next page of results to return.
     * </p>
     * 
     * @return Identifies the next page of results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(documentClassificationJobPropertiesList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentClassificationJobsResponse)) {
            return false;
        }
        ListDocumentClassificationJobsResponse other = (ListDocumentClassificationJobsResponse) obj;
        return Objects.equals(documentClassificationJobPropertiesList(), other.documentClassificationJobPropertiesList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDocumentClassificationJobsResponse")
                .add("DocumentClassificationJobPropertiesList", documentClassificationJobPropertiesList())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentClassificationJobPropertiesList":
            return Optional.ofNullable(clazz.cast(documentClassificationJobPropertiesList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDocumentClassificationJobsResponse, T> g) {
        return obj -> g.apply((ListDocumentClassificationJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDocumentClassificationJobsResponse> {
        /**
         * <p>
         * A list containing the properties of each job returned.
         * </p>
         * 
         * @param documentClassificationJobPropertiesList
         *        A list containing the properties of each job returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentClassificationJobPropertiesList(
                Collection<DocumentClassificationJobProperties> documentClassificationJobPropertiesList);

        /**
         * <p>
         * A list containing the properties of each job returned.
         * </p>
         * 
         * @param documentClassificationJobPropertiesList
         *        A list containing the properties of each job returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentClassificationJobPropertiesList(
                DocumentClassificationJobProperties... documentClassificationJobPropertiesList);

        /**
         * <p>
         * A list containing the properties of each job returned.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <DocumentClassificationJobProperties>.Builder} avoiding the need to create one manually via {@link List
         * <DocumentClassificationJobProperties>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DocumentClassificationJobProperties>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #documentClassificationJobPropertiesList(List<DocumentClassificationJobProperties>)}.
         * 
         * @param documentClassificationJobPropertiesList
         *        a consumer that will call methods on {@link List<DocumentClassificationJobProperties>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentClassificationJobPropertiesList(List<DocumentClassificationJobProperties>)
         */
        Builder documentClassificationJobPropertiesList(
                Consumer<DocumentClassificationJobProperties.Builder>... documentClassificationJobPropertiesList);

        /**
         * <p>
         * Identifies the next page of results to return.
         * </p>
         * 
         * @param nextToken
         *        Identifies the next page of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<DocumentClassificationJobProperties> documentClassificationJobPropertiesList = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentClassificationJobsResponse model) {
            super(model);
            documentClassificationJobPropertiesList(model.documentClassificationJobPropertiesList);
            nextToken(model.nextToken);
        }

        public final Collection<DocumentClassificationJobProperties.Builder> getDocumentClassificationJobPropertiesList() {
            return documentClassificationJobPropertiesList != null ? documentClassificationJobPropertiesList.stream()
                    .map(DocumentClassificationJobProperties::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documentClassificationJobPropertiesList(
                Collection<DocumentClassificationJobProperties> documentClassificationJobPropertiesList) {
            this.documentClassificationJobPropertiesList = DocumentClassificationJobPropertiesListCopier
                    .copy(documentClassificationJobPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentClassificationJobPropertiesList(
                DocumentClassificationJobProperties... documentClassificationJobPropertiesList) {
            documentClassificationJobPropertiesList(Arrays.asList(documentClassificationJobPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentClassificationJobPropertiesList(
                Consumer<DocumentClassificationJobProperties.Builder>... documentClassificationJobPropertiesList) {
            documentClassificationJobPropertiesList(Stream.of(documentClassificationJobPropertiesList)
                    .map(c -> DocumentClassificationJobProperties.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDocumentClassificationJobPropertiesList(
                Collection<DocumentClassificationJobProperties.BuilderImpl> documentClassificationJobPropertiesList) {
            this.documentClassificationJobPropertiesList = DocumentClassificationJobPropertiesListCopier
                    .copyFromBuilder(documentClassificationJobPropertiesList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDocumentClassificationJobsResponse build() {
            return new ListDocumentClassificationJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
