/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClassifyDocumentResponse extends ComprehendResponse implements
        ToCopyableBuilder<ClassifyDocumentResponse.Builder, ClassifyDocumentResponse> {
    private static final SdkField<List<DocumentClass>> CLASSES_FIELD = SdkField
            .<List<DocumentClass>> builder(MarshallingType.LIST)
            .getter(getter(ClassifyDocumentResponse::classes))
            .setter(setter(Builder::classes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentClass> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentClass::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DocumentLabel>> LABELS_FIELD = SdkField
            .<List<DocumentLabel>> builder(MarshallingType.LIST)
            .getter(getter(ClassifyDocumentResponse::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentLabel> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentLabel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLASSES_FIELD, LABELS_FIELD));

    private final List<DocumentClass> classes;

    private final List<DocumentLabel> labels;

    private ClassifyDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.classes = builder.classes;
        this.labels = builder.labels;
    }

    /**
     * Returns true if the Classes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasClasses() {
        return classes != null && !(classes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The classes used by the document being analyzed. These are used for multi-class trained models. Individual
     * classes are mutually exclusive and each document is expected to have only a single class assigned to it. For
     * example, an animal can be a dog or a cat, but not both at the same time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasClasses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The classes used by the document being analyzed. These are used for multi-class trained models.
     *         Individual classes are mutually exclusive and each document is expected to have only a single class
     *         assigned to it. For example, an animal can be a dog or a cat, but not both at the same time.
     */
    public List<DocumentClass> classes() {
        return classes;
    }

    /**
     * Returns true if the Labels property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The labels used the document being analyzed. These are used for multi-label trained models. Individual labels
     * represent different categories that are related in some manner and are not multually exclusive. For example, a
     * movie can be just an action movie, or it can be an action movie, a science fiction movie, and a comedy, all at
     * the same time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLabels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The labels used the document being analyzed. These are used for multi-label trained models. Individual
     *         labels represent different categories that are related in some manner and are not multually exclusive.
     *         For example, a movie can be just an action movie, or it can be an action movie, a science fiction movie,
     *         and a comedy, all at the same time.
     */
    public List<DocumentLabel> labels() {
        return labels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(classes());
        hashCode = 31 * hashCode + Objects.hashCode(labels());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassifyDocumentResponse)) {
            return false;
        }
        ClassifyDocumentResponse other = (ClassifyDocumentResponse) obj;
        return Objects.equals(classes(), other.classes()) && Objects.equals(labels(), other.labels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ClassifyDocumentResponse").add("Classes", classes()).add("Labels", labels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Classes":
            return Optional.ofNullable(clazz.cast(classes()));
        case "Labels":
            return Optional.ofNullable(clazz.cast(labels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClassifyDocumentResponse, T> g) {
        return obj -> g.apply((ClassifyDocumentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo, CopyableBuilder<Builder, ClassifyDocumentResponse> {
        /**
         * <p>
         * The classes used by the document being analyzed. These are used for multi-class trained models. Individual
         * classes are mutually exclusive and each document is expected to have only a single class assigned to it. For
         * example, an animal can be a dog or a cat, but not both at the same time.
         * </p>
         * 
         * @param classes
         *        The classes used by the document being analyzed. These are used for multi-class trained models.
         *        Individual classes are mutually exclusive and each document is expected to have only a single class
         *        assigned to it. For example, an animal can be a dog or a cat, but not both at the same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classes(Collection<DocumentClass> classes);

        /**
         * <p>
         * The classes used by the document being analyzed. These are used for multi-class trained models. Individual
         * classes are mutually exclusive and each document is expected to have only a single class assigned to it. For
         * example, an animal can be a dog or a cat, but not both at the same time.
         * </p>
         * 
         * @param classes
         *        The classes used by the document being analyzed. These are used for multi-class trained models.
         *        Individual classes are mutually exclusive and each document is expected to have only a single class
         *        assigned to it. For example, an animal can be a dog or a cat, but not both at the same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classes(DocumentClass... classes);

        /**
         * <p>
         * The classes used by the document being analyzed. These are used for multi-class trained models. Individual
         * classes are mutually exclusive and each document is expected to have only a single class assigned to it. For
         * example, an animal can be a dog or a cat, but not both at the same time.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DocumentClass>.Builder} avoiding the need
         * to create one manually via {@link List<DocumentClass>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DocumentClass>.Builder#build()} is called immediately and
         * its result is passed to {@link #classes(List<DocumentClass>)}.
         * 
         * @param classes
         *        a consumer that will call methods on {@link List<DocumentClass>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #classes(List<DocumentClass>)
         */
        Builder classes(Consumer<DocumentClass.Builder>... classes);

        /**
         * <p>
         * The labels used the document being analyzed. These are used for multi-label trained models. Individual labels
         * represent different categories that are related in some manner and are not multually exclusive. For example,
         * a movie can be just an action movie, or it can be an action movie, a science fiction movie, and a comedy, all
         * at the same time.
         * </p>
         * 
         * @param labels
         *        The labels used the document being analyzed. These are used for multi-label trained models. Individual
         *        labels represent different categories that are related in some manner and are not multually exclusive.
         *        For example, a movie can be just an action movie, or it can be an action movie, a science fiction
         *        movie, and a comedy, all at the same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<DocumentLabel> labels);

        /**
         * <p>
         * The labels used the document being analyzed. These are used for multi-label trained models. Individual labels
         * represent different categories that are related in some manner and are not multually exclusive. For example,
         * a movie can be just an action movie, or it can be an action movie, a science fiction movie, and a comedy, all
         * at the same time.
         * </p>
         * 
         * @param labels
         *        The labels used the document being analyzed. These are used for multi-label trained models. Individual
         *        labels represent different categories that are related in some manner and are not multually exclusive.
         *        For example, a movie can be just an action movie, or it can be an action movie, a science fiction
         *        movie, and a comedy, all at the same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(DocumentLabel... labels);

        /**
         * <p>
         * The labels used the document being analyzed. These are used for multi-label trained models. Individual labels
         * represent different categories that are related in some manner and are not multually exclusive. For example,
         * a movie can be just an action movie, or it can be an action movie, a science fiction movie, and a comedy, all
         * at the same time.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DocumentLabel>.Builder} avoiding the need
         * to create one manually via {@link List<DocumentLabel>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DocumentLabel>.Builder#build()} is called immediately and
         * its result is passed to {@link #labels(List<DocumentLabel>)}.
         * 
         * @param labels
         *        a consumer that will call methods on {@link List<DocumentLabel>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labels(List<DocumentLabel>)
         */
        Builder labels(Consumer<DocumentLabel.Builder>... labels);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<DocumentClass> classes = DefaultSdkAutoConstructList.getInstance();

        private List<DocumentLabel> labels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClassifyDocumentResponse model) {
            super(model);
            classes(model.classes);
            labels(model.labels);
        }

        public final Collection<DocumentClass.Builder> getClasses() {
            return classes != null ? classes.stream().map(DocumentClass::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder classes(Collection<DocumentClass> classes) {
            this.classes = ListOfClassesCopier.copy(classes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classes(DocumentClass... classes) {
            classes(Arrays.asList(classes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classes(Consumer<DocumentClass.Builder>... classes) {
            classes(Stream.of(classes).map(c -> DocumentClass.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClasses(Collection<DocumentClass.BuilderImpl> classes) {
            this.classes = ListOfClassesCopier.copyFromBuilder(classes);
        }

        public final Collection<DocumentLabel.Builder> getLabels() {
            return labels != null ? labels.stream().map(DocumentLabel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder labels(Collection<DocumentLabel> labels) {
            this.labels = ListOfLabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(DocumentLabel... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Consumer<DocumentLabel.Builder>... labels) {
            labels(Stream.of(labels).map(c -> DocumentLabel.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLabels(Collection<DocumentLabel.BuilderImpl> labels) {
            this.labels = ListOfLabelsCopier.copyFromBuilder(labels);
        }

        @Override
        public ClassifyDocumentResponse build() {
            return new ClassifyDocumentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
