/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageItemResult;
import software.amazon.awssdk.services.comprehend.model.BatchItemError;
import software.amazon.awssdk.services.comprehend.model.BatchItemErrorListCopier;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.ListOfDetectDominantLanguageResultCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchDetectDominantLanguageResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, BatchDetectDominantLanguageResponse> {
    private final List<BatchDetectDominantLanguageItemResult> resultList;
    private final List<BatchItemError> errorList;

    private BatchDetectDominantLanguageResponse(BuilderImpl builder) {
        super(builder);
        this.resultList = builder.resultList;
        this.errorList = builder.errorList;
    }

    public List<BatchDetectDominantLanguageItemResult> resultList() {
        return this.resultList;
    }

    public List<BatchItemError> errorList() {
        return this.errorList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resultList());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectDominantLanguageResponse)) {
            return false;
        }
        BatchDetectDominantLanguageResponse other = (BatchDetectDominantLanguageResponse)((Object)obj);
        return Objects.equals(this.resultList(), other.resultList()) && Objects.equals(this.errorList(), other.errorList());
    }

    public String toString() {
        return ToString.builder((String)"BatchDetectDominantLanguageResponse").add("ResultList", this.resultList()).add("ErrorList", this.errorList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResultList": {
                return Optional.of(clazz.cast(this.resultList()));
            }
            case "ErrorList": {
                return Optional.of(clazz.cast(this.errorList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<BatchDetectDominantLanguageItemResult> resultList;
        private List<BatchItemError> errorList;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectDominantLanguageResponse model) {
            this.resultList(model.resultList);
            this.errorList(model.errorList);
        }

        public final Collection<BatchDetectDominantLanguageItemResult.Builder> getResultList() {
            return this.resultList != null ? (Collection)this.resultList.stream().map(BatchDetectDominantLanguageItemResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resultList(Collection<BatchDetectDominantLanguageItemResult> resultList) {
            this.resultList = ListOfDetectDominantLanguageResultCopier.copy(resultList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultList(BatchDetectDominantLanguageItemResult ... resultList) {
            this.resultList(Arrays.asList(resultList));
            return this;
        }

        public final void setResultList(Collection<BatchDetectDominantLanguageItemResult.BuilderImpl> resultList) {
            this.resultList = ListOfDetectDominantLanguageResultCopier.copyFromBuilder(resultList);
        }

        public final Collection<BatchItemError.Builder> getErrorList() {
            return this.errorList != null ? (Collection)this.errorList.stream().map(BatchItemError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errorList(Collection<BatchItemError> errorList) {
            this.errorList = BatchItemErrorListCopier.copy(errorList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorList(BatchItemError ... errorList) {
            this.errorList(Arrays.asList(errorList));
            return this;
        }

        public final void setErrorList(Collection<BatchItemError.BuilderImpl> errorList) {
            this.errorList = BatchItemErrorListCopier.copyFromBuilder(errorList);
        }

        @Override
        public BatchDetectDominantLanguageResponse build() {
            return new BatchDetectDominantLanguageResponse(this);
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    CopyableBuilder<Builder, BatchDetectDominantLanguageResponse> {
        public Builder resultList(Collection<BatchDetectDominantLanguageItemResult> var1);

        public Builder resultList(BatchDetectDominantLanguageItemResult ... var1);

        public Builder errorList(Collection<BatchItemError> var1);

        public Builder errorList(BatchItemError ... var1);
    }
}

