/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.comprehend.model.SentimentScore;

public class SentimentScoreUnmarshaller
implements Unmarshaller<SentimentScore, JsonUnmarshallerContext> {
    private static final SentimentScoreUnmarshaller INSTANCE = new SentimentScoreUnmarshaller();

    public SentimentScore unmarshall(JsonUnmarshallerContext context) throws Exception {
        SentimentScore.Builder sentimentScoreBuilder = SentimentScore.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Positive", targetDepth)) {
                    context.nextToken();
                    sentimentScoreBuilder.positive((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
                if (context.testExpression("Negative", targetDepth)) {
                    context.nextToken();
                    sentimentScoreBuilder.negative((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
                if (context.testExpression("Neutral", targetDepth)) {
                    context.nextToken();
                    sentimentScoreBuilder.neutral((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
                if (context.testExpression("Mixed", targetDepth)) {
                    context.nextToken();
                    sentimentScoreBuilder.mixed((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SentimentScore)sentimentScoreBuilder.build();
    }

    public static SentimentScoreUnmarshaller getInstance() {
        return INSTANCE;
    }
}

