/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.comprehend.model.InputDataConfig;

public class InputDataConfigUnmarshaller
implements Unmarshaller<InputDataConfig, JsonUnmarshallerContext> {
    private static final InputDataConfigUnmarshaller INSTANCE = new InputDataConfigUnmarshaller();

    public InputDataConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        InputDataConfig.Builder inputDataConfigBuilder = InputDataConfig.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("S3Uri", targetDepth)) {
                    context.nextToken();
                    inputDataConfigBuilder.s3Uri((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InputFormat", targetDepth)) {
                    context.nextToken();
                    inputDataConfigBuilder.inputFormat((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (InputDataConfig)inputDataConfigBuilder.build();
    }

    public static InputDataConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

