/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.comprehend.ComprehendClient;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse;

public final class ListTopicsDetectionJobsPaginator
implements SdkIterable<ListTopicsDetectionJobsResponse> {
    private final ComprehendClient client;
    private final ListTopicsDetectionJobsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListTopicsDetectionJobsPaginator(ComprehendClient client, ListTopicsDetectionJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTopicsDetectionJobsResponseFetcher();
    }

    public Iterator<ListTopicsDetectionJobsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListTopicsDetectionJobsResponseFetcher
    implements NextPageFetcher<ListTopicsDetectionJobsResponse> {
        private ListTopicsDetectionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListTopicsDetectionJobsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListTopicsDetectionJobsResponse nextPage(ListTopicsDetectionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListTopicsDetectionJobsPaginator.this.client.listTopicsDetectionJobs(ListTopicsDetectionJobsPaginator.this.firstRequest);
            }
            return ListTopicsDetectionJobsPaginator.this.client.listTopicsDetectionJobs((ListTopicsDetectionJobsRequest)((Object)ListTopicsDetectionJobsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

