/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.DominantLanguage;
import software.amazon.awssdk.services.comprehend.model.ListOfDominantLanguagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DetectDominantLanguageResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, DetectDominantLanguageResponse> {
    private final List<DominantLanguage> languages;

    private DetectDominantLanguageResponse(BuilderImpl builder) {
        super(builder);
        this.languages = builder.languages;
    }

    public List<DominantLanguage> languages() {
        return this.languages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.languages());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectDominantLanguageResponse)) {
            return false;
        }
        DetectDominantLanguageResponse other = (DetectDominantLanguageResponse)((Object)obj);
        return Objects.equals(this.languages(), other.languages());
    }

    public String toString() {
        return ToString.builder((String)"DetectDominantLanguageResponse").add("Languages", this.languages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Languages": {
                return Optional.of(clazz.cast(this.languages()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<DominantLanguage> languages;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectDominantLanguageResponse model) {
            this.languages(model.languages);
        }

        public final Collection<DominantLanguage.Builder> getLanguages() {
            return this.languages != null ? (Collection)this.languages.stream().map(DominantLanguage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder languages(Collection<DominantLanguage> languages) {
            this.languages = ListOfDominantLanguagesCopier.copy(languages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(DominantLanguage ... languages) {
            this.languages(Arrays.asList(languages));
            return this;
        }

        public final void setLanguages(Collection<DominantLanguage.BuilderImpl> languages) {
            this.languages = ListOfDominantLanguagesCopier.copyFromBuilder(languages);
        }

        @Override
        public DetectDominantLanguageResponse build() {
            return new DetectDominantLanguageResponse(this);
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    CopyableBuilder<Builder, DetectDominantLanguageResponse> {
        public Builder languages(Collection<DominantLanguage> var1);

        public Builder languages(DominantLanguage ... var1);
    }
}

