/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClient;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse;

public class ListEntitiesDetectionJobsPublisher
implements SdkPublisher<ListEntitiesDetectionJobsResponse> {
    private final ComprehendAsyncClient client;
    private final ListEntitiesDetectionJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEntitiesDetectionJobsPublisher(ComprehendAsyncClient client, ListEntitiesDetectionJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEntitiesDetectionJobsPublisher(ComprehendAsyncClient client, ListEntitiesDetectionJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEntitiesDetectionJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEntitiesDetectionJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListEntitiesDetectionJobsPublisher resume(ListEntitiesDetectionJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListEntitiesDetectionJobsPublisher(this.client, (ListEntitiesDetectionJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListEntitiesDetectionJobsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListEntitiesDetectionJobsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListEntitiesDetectionJobsResponseFetcher
    implements AsyncPageFetcher<ListEntitiesDetectionJobsResponse> {
        private ListEntitiesDetectionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListEntitiesDetectionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEntitiesDetectionJobsResponse> nextPage(ListEntitiesDetectionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListEntitiesDetectionJobsPublisher.this.client.listEntitiesDetectionJobs(ListEntitiesDetectionJobsPublisher.this.firstRequest);
            }
            return ListEntitiesDetectionJobsPublisher.this.client.listEntitiesDetectionJobs((ListEntitiesDetectionJobsRequest)((Object)ListEntitiesDetectionJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

