/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StartKeyPhrasesDetectionJobRequestModelMarshaller {
    private static final MarshallingInfo<StructuredPojo> INPUTDATACONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputDataConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTDATACONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputDataConfig").isBinary(false).build();
    private static final MarshallingInfo<String> DATAACCESSROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataAccessRoleArn").isBinary(false).build();
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LanguageCode").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTREQUESTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientRequestToken").isBinary(false).defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final StartKeyPhrasesDetectionJobRequestModelMarshaller INSTANCE = new StartKeyPhrasesDetectionJobRequestModelMarshaller();

    private StartKeyPhrasesDetectionJobRequestModelMarshaller() {
    }

    public static StartKeyPhrasesDetectionJobRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StartKeyPhrasesDetectionJobRequest startKeyPhrasesDetectionJobRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)startKeyPhrasesDetectionJobRequest), (String)"startKeyPhrasesDetectionJobRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)startKeyPhrasesDetectionJobRequest.inputDataConfig(), INPUTDATACONFIG_BINDING);
            protocolMarshaller.marshall((Object)startKeyPhrasesDetectionJobRequest.outputDataConfig(), OUTPUTDATACONFIG_BINDING);
            protocolMarshaller.marshall((Object)startKeyPhrasesDetectionJobRequest.dataAccessRoleArn(), DATAACCESSROLEARN_BINDING);
            protocolMarshaller.marshall((Object)startKeyPhrasesDetectionJobRequest.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)startKeyPhrasesDetectionJobRequest.languageCodeAsString(), LANGUAGECODE_BINDING);
            protocolMarshaller.marshall((Object)startKeyPhrasesDetectionJobRequest.clientRequestToken(), CLIENTREQUESTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

