/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.comprehend.model.SentimentDetectionJobProperties;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SentimentDetectionJobPropertiesMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobId").isBinary(false).build();
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").isBinary(false).build();
    private static final MarshallingInfo<String> JOBSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobStatus").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").isBinary(false).build();
    private static final MarshallingInfo<Instant> SUBMITTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubmitTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INPUTDATACONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputDataConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTDATACONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputDataConfig").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LanguageCode").isBinary(false).build();
    private static final MarshallingInfo<String> DATAACCESSROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataAccessRoleArn").isBinary(false).build();
    private static final SentimentDetectionJobPropertiesMarshaller INSTANCE = new SentimentDetectionJobPropertiesMarshaller();

    private SentimentDetectionJobPropertiesMarshaller() {
    }

    public static SentimentDetectionJobPropertiesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SentimentDetectionJobProperties sentimentDetectionJobProperties, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sentimentDetectionJobProperties, (String)"sentimentDetectionJobProperties");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sentimentDetectionJobProperties.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)sentimentDetectionJobProperties.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)sentimentDetectionJobProperties.jobStatusAsString(), JOBSTATUS_BINDING);
            protocolMarshaller.marshall((Object)sentimentDetectionJobProperties.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)sentimentDetectionJobProperties.submitTime(), SUBMITTIME_BINDING);
            protocolMarshaller.marshall((Object)sentimentDetectionJobProperties.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)sentimentDetectionJobProperties.inputDataConfig(), INPUTDATACONFIG_BINDING);
            protocolMarshaller.marshall((Object)sentimentDetectionJobProperties.outputDataConfig(), OUTPUTDATACONFIG_BINDING);
            protocolMarshaller.marshall((Object)sentimentDetectionJobProperties.languageCodeAsString(), LANGUAGECODE_BINDING);
            protocolMarshaller.marshall((Object)sentimentDetectionJobProperties.dataAccessRoleArn(), DATAACCESSROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

