/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.comprehend.model.InputDataConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InputDataConfigMarshaller {
    private static final MarshallingInfo<String> S3URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Uri").isBinary(false).build();
    private static final MarshallingInfo<String> INPUTFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputFormat").isBinary(false).build();
    private static final InputDataConfigMarshaller INSTANCE = new InputDataConfigMarshaller();

    private InputDataConfigMarshaller() {
    }

    public static InputDataConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputDataConfig inputDataConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)inputDataConfig, (String)"inputDataConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)inputDataConfig.s3Uri(), S3URI_BINDING);
            protocolMarshaller.marshall((Object)inputDataConfig.inputFormatAsString(), INPUTFORMAT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

