/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.comprehend.model.DominantLanguageDetectionJobProperties;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DominantLanguageDetectionJobPropertiesMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobId").isBinary(false).build();
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").isBinary(false).build();
    private static final MarshallingInfo<String> JOBSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobStatus").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").isBinary(false).build();
    private static final MarshallingInfo<Instant> SUBMITTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubmitTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INPUTDATACONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputDataConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTDATACONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputDataConfig").isBinary(false).build();
    private static final MarshallingInfo<String> DATAACCESSROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataAccessRoleArn").isBinary(false).build();
    private static final DominantLanguageDetectionJobPropertiesMarshaller INSTANCE = new DominantLanguageDetectionJobPropertiesMarshaller();

    private DominantLanguageDetectionJobPropertiesMarshaller() {
    }

    public static DominantLanguageDetectionJobPropertiesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DominantLanguageDetectionJobProperties dominantLanguageDetectionJobProperties, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dominantLanguageDetectionJobProperties, (String)"dominantLanguageDetectionJobProperties");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dominantLanguageDetectionJobProperties.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)dominantLanguageDetectionJobProperties.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)dominantLanguageDetectionJobProperties.jobStatusAsString(), JOBSTATUS_BINDING);
            protocolMarshaller.marshall((Object)dominantLanguageDetectionJobProperties.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)dominantLanguageDetectionJobProperties.submitTime(), SUBMITTIME_BINDING);
            protocolMarshaller.marshall((Object)dominantLanguageDetectionJobProperties.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)dominantLanguageDetectionJobProperties.inputDataConfig(), INPUTDATACONFIG_BINDING);
            protocolMarshaller.marshall((Object)dominantLanguageDetectionJobProperties.outputDataConfig(), OUTPUTDATACONFIG_BINDING);
            protocolMarshaller.marshall((Object)dominantLanguageDetectionJobProperties.dataAccessRoleArn(), DATAACCESSROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

