/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectKeyPhrasesRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchDetectKeyPhrasesRequestMarshaller
implements Marshaller<Request<BatchDetectKeyPhrasesRequest>, BatchDetectKeyPhrasesRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("Comprehend_20171127.BatchDetectKeyPhrases").serviceName("Amazon Comprehend").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public BatchDetectKeyPhrasesRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<BatchDetectKeyPhrasesRequest> marshall(BatchDetectKeyPhrasesRequest batchDetectKeyPhrasesRequest) {
        Validate.paramNotNull((Object)((Object)batchDetectKeyPhrasesRequest), (String)"batchDetectKeyPhrasesRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)batchDetectKeyPhrasesRequest);
            protocolMarshaller.startMarshalling();
            BatchDetectKeyPhrasesRequestModelMarshaller.getInstance().marshall(batchDetectKeyPhrasesRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

