/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.comprehend.model.TopicsDetectionJobProperties;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TopicsDetectionJobPropertiesMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobId").isBinary(false).build();
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").isBinary(false).build();
    private static final MarshallingInfo<String> JOBSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobStatus").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").isBinary(false).build();
    private static final MarshallingInfo<Instant> SUBMITTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubmitTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INPUTDATACONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputDataConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTDATACONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputDataConfig").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBEROFTOPICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfTopics").isBinary(false).build();
    private static final TopicsDetectionJobPropertiesMarshaller INSTANCE = new TopicsDetectionJobPropertiesMarshaller();

    private TopicsDetectionJobPropertiesMarshaller() {
    }

    public static TopicsDetectionJobPropertiesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TopicsDetectionJobProperties topicsDetectionJobProperties, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)topicsDetectionJobProperties, (String)"topicsDetectionJobProperties");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)topicsDetectionJobProperties.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)topicsDetectionJobProperties.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)topicsDetectionJobProperties.jobStatusAsString(), JOBSTATUS_BINDING);
            protocolMarshaller.marshall((Object)topicsDetectionJobProperties.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)topicsDetectionJobProperties.submitTime(), SUBMITTIME_BINDING);
            protocolMarshaller.marshall((Object)topicsDetectionJobProperties.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)topicsDetectionJobProperties.inputDataConfig(), INPUTDATACONFIG_BINDING);
            protocolMarshaller.marshall((Object)topicsDetectionJobProperties.outputDataConfig(), OUTPUTDATACONFIG_BINDING);
            protocolMarshaller.marshall((Object)topicsDetectionJobProperties.numberOfTopics(), NUMBEROFTOPICS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

