/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchDetectSentimentRequestModelMarshaller {
    private static final MarshallingInfo<List> TEXTLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TextList").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LanguageCode").isBinary(false).build();
    private static final BatchDetectSentimentRequestModelMarshaller INSTANCE = new BatchDetectSentimentRequestModelMarshaller();

    private BatchDetectSentimentRequestModelMarshaller() {
    }

    public static BatchDetectSentimentRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchDetectSentimentRequest batchDetectSentimentRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)batchDetectSentimentRequest), (String)"batchDetectSentimentRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(batchDetectSentimentRequest.textList(), TEXTLIST_BINDING);
            protocolMarshaller.marshall((Object)batchDetectSentimentRequest.languageCode(), LANGUAGECODE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

