/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.Entity;
import software.amazon.awssdk.services.comprehend.model.ListOfEntitiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectEntitiesResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, DetectEntitiesResponse> {
    private final List<Entity> entities;

    private DetectEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
    }

    public List<Entity> entities() {
        return this.entities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entities());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectEntitiesResponse)) {
            return false;
        }
        DetectEntitiesResponse other = (DetectEntitiesResponse)((Object)obj);
        return Objects.equals(this.entities(), other.entities());
    }

    public String toString() {
        return ToString.builder((String)"DetectEntitiesResponse").add("Entities", this.entities()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<Entity> entities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectEntitiesResponse model) {
            super(model);
            this.entities(model.entities);
        }

        public final Collection<Entity.Builder> getEntities() {
            return this.entities != null ? (Collection)this.entities.stream().map(Entity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entities(Collection<Entity> entities) {
            this.entities = ListOfEntitiesCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Entity ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<Entity.Builder> ... entities) {
            this.entities(Stream.of(entities).map(c -> (Entity)((Entity.Builder)Entity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntities(Collection<Entity.BuilderImpl> entities) {
            this.entities = ListOfEntitiesCopier.copyFromBuilder(entities);
        }

        @Override
        public DetectEntitiesResponse build() {
            return new DetectEntitiesResponse(this);
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    CopyableBuilder<Builder, DetectEntitiesResponse> {
        public Builder entities(Collection<Entity> var1);

        public Builder entities(Entity ... var1);

        public Builder entities(Consumer<Entity.Builder> ... var1);
    }
}

