/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.services.comprehend.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDetectKeyPhrasesRequest
extends ComprehendRequest
implements ToCopyableBuilder<Builder, BatchDetectKeyPhrasesRequest> {
    private final List<String> textList;
    private final String languageCode;

    private BatchDetectKeyPhrasesRequest(BuilderImpl builder) {
        super(builder);
        this.textList = builder.textList;
        this.languageCode = builder.languageCode;
    }

    public List<String> textList() {
        return this.textList;
    }

    public String languageCode() {
        return this.languageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.textList());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectKeyPhrasesRequest)) {
            return false;
        }
        BatchDetectKeyPhrasesRequest other = (BatchDetectKeyPhrasesRequest)((Object)obj);
        return Objects.equals(this.textList(), other.textList()) && Objects.equals(this.languageCode(), other.languageCode());
    }

    public String toString() {
        return ToString.builder((String)"BatchDetectKeyPhrasesRequest").add("TextList", this.textList()).add("LanguageCode", (Object)this.languageCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TextList": {
                return Optional.ofNullable(clazz.cast(this.textList()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCode()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ComprehendRequest.BuilderImpl
    implements Builder {
        private List<String> textList = DefaultSdkAutoConstructList.getInstance();
        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectKeyPhrasesRequest model) {
            super(model);
            this.textList(model.textList);
            this.languageCode(model.languageCode);
        }

        public final Collection<String> getTextList() {
            return this.textList;
        }

        @Override
        public final Builder textList(Collection<String> textList) {
            this.textList = StringListCopier.copy(textList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textList(String ... textList) {
            this.textList(Arrays.asList(textList));
            return this;
        }

        public final void setTextList(Collection<String> textList) {
            this.textList = StringListCopier.copy(textList);
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDetectKeyPhrasesRequest build() {
            return new BatchDetectKeyPhrasesRequest(this);
        }
    }

    public static interface Builder
    extends ComprehendRequest.Builder,
    CopyableBuilder<Builder, BatchDetectKeyPhrasesRequest> {
        public Builder textList(Collection<String> var1);

        public Builder textList(String ... var1);

        public Builder languageCode(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

