/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DetectSentimentRequestModelMarshaller {
    private static final MarshallingInfo<String> TEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Text").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LanguageCode").isBinary(false).build();
    private static final DetectSentimentRequestModelMarshaller INSTANCE = new DetectSentimentRequestModelMarshaller();

    private DetectSentimentRequestModelMarshaller() {
    }

    public static DetectSentimentRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DetectSentimentRequest detectSentimentRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)detectSentimentRequest), (String)"detectSentimentRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)detectSentimentRequest.text(), TEXT_BINDING);
            protocolMarshaller.marshall((Object)detectSentimentRequest.languageCodeAsString(), LANGUAGECODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

