/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SentimentType {
    POSITIVE("POSITIVE"),
    NEGATIVE("NEGATIVE"),
    NEUTRAL("NEUTRAL"),
    MIXED("MIXED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SentimentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SentimentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SentimentType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SentimentType> knownValues() {
        return Stream.of(SentimentType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

