/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.services.comprehend.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchDetectSentimentRequest
extends ComprehendRequest
implements ToCopyableBuilder<Builder, BatchDetectSentimentRequest> {
    private final List<String> textList;
    private final String languageCode;

    private BatchDetectSentimentRequest(BuilderImpl builder) {
        super(builder);
        this.textList = builder.textList;
        this.languageCode = builder.languageCode;
    }

    public List<String> textList() {
        return this.textList;
    }

    public String languageCode() {
        return this.languageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.textList());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectSentimentRequest)) {
            return false;
        }
        BatchDetectSentimentRequest other = (BatchDetectSentimentRequest)((Object)obj);
        return Objects.equals(this.textList(), other.textList()) && Objects.equals(this.languageCode(), other.languageCode());
    }

    public String toString() {
        return ToString.builder((String)"BatchDetectSentimentRequest").add("TextList", this.textList()).add("LanguageCode", (Object)this.languageCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TextList": {
                return Optional.of(clazz.cast(this.textList()));
            }
            case "LanguageCode": {
                return Optional.of(clazz.cast(this.languageCode()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ComprehendRequest.BuilderImpl
    implements Builder {
        private List<String> textList;
        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectSentimentRequest model) {
            super(model);
            this.textList(model.textList);
            this.languageCode(model.languageCode);
        }

        public final Collection<String> getTextList() {
            return this.textList;
        }

        @Override
        public final Builder textList(Collection<String> textList) {
            this.textList = StringListCopier.copy(textList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textList(String ... textList) {
            this.textList(Arrays.asList(textList));
            return this;
        }

        public final void setTextList(Collection<String> textList) {
            this.textList = StringListCopier.copy(textList);
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public BatchDetectSentimentRequest build() {
            return new BatchDetectSentimentRequest(this);
        }
    }

    public static interface Builder
    extends ComprehendRequest.Builder,
    CopyableBuilder<Builder, BatchDetectSentimentRequest> {
        public Builder textList(Collection<String> var1);

        public Builder textList(String ... var1);

        public Builder languageCode(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

