/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.comprehend.model.DominantLanguage;
import software.amazon.awssdk.services.comprehend.model.ListOfDominantLanguagesCopier;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectDominantLanguageItemResultMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchDetectDominantLanguageItemResult
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchDetectDominantLanguageItemResult> {
    private final Integer index;
    private final List<DominantLanguage> languages;

    private BatchDetectDominantLanguageItemResult(BuilderImpl builder) {
        this.index = builder.index;
        this.languages = builder.languages;
    }

    public Integer index() {
        return this.index;
    }

    public List<DominantLanguage> languages() {
        return this.languages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.languages());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectDominantLanguageItemResult)) {
            return false;
        }
        BatchDetectDominantLanguageItemResult other = (BatchDetectDominantLanguageItemResult)obj;
        return Objects.equals(this.index(), other.index()) && Objects.equals(this.languages(), other.languages());
    }

    public String toString() {
        return ToString.builder((String)"BatchDetectDominantLanguageItemResult").add("Index", (Object)this.index()).add("Languages", this.languages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Index": {
                return Optional.of(clazz.cast(this.index()));
            }
            case "Languages": {
                return Optional.of(clazz.cast(this.languages()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchDetectDominantLanguageItemResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer index;
        private List<DominantLanguage> languages;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectDominantLanguageItemResult model) {
            this.index(model.index);
            this.languages(model.languages);
        }

        public final Integer getIndex() {
            return this.index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        public final Collection<DominantLanguage.Builder> getLanguages() {
            return this.languages != null ? (Collection)this.languages.stream().map(DominantLanguage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder languages(Collection<DominantLanguage> languages) {
            this.languages = ListOfDominantLanguagesCopier.copy(languages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(DominantLanguage ... languages) {
            this.languages(Arrays.asList(languages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(Consumer<DominantLanguage.Builder> ... languages) {
            this.languages(Stream.of(languages).map(c -> (DominantLanguage)((DominantLanguage.Builder)DominantLanguage.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLanguages(Collection<DominantLanguage.BuilderImpl> languages) {
            this.languages = ListOfDominantLanguagesCopier.copyFromBuilder(languages);
        }

        public BatchDetectDominantLanguageItemResult build() {
            return new BatchDetectDominantLanguageItemResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchDetectDominantLanguageItemResult> {
        public Builder index(Integer var1);

        public Builder languages(Collection<DominantLanguage> var1);

        public Builder languages(DominantLanguage ... var1);

        public Builder languages(Consumer<DominantLanguage.Builder> ... var1);
    }
}

