/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request for a list of records.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecordsRequest extends CognitoSyncRequest implements
        ToCopyableBuilder<ListRecordsRequest.Builder, ListRecordsRequest> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityPoolId").getter(getter(ListRecordsRequest::identityPoolId))
            .setter(setter(Builder::identityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("IdentityPoolId").build()).build();

    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityId").getter(getter(ListRecordsRequest::identityId)).setter(setter(Builder::identityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("IdentityId").build()).build();

    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(ListRecordsRequest::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DatasetName").build()).build();

    private static final SdkField<Long> LAST_SYNC_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LastSyncCount").getter(getter(ListRecordsRequest::lastSyncCount)).setter(setter(Builder::lastSyncCount))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("lastSyncCount").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRecordsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListRecordsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> SYNC_SESSION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SyncSessionToken").getter(getter(ListRecordsRequest::syncSessionToken))
            .setter(setter(Builder::syncSessionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("syncSessionToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD,
            IDENTITY_ID_FIELD, DATASET_NAME_FIELD, LAST_SYNC_COUNT_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD,
            SYNC_SESSION_TOKEN_FIELD));

    private final String identityPoolId;

    private final String identityId;

    private final String datasetName;

    private final Long lastSyncCount;

    private final String nextToken;

    private final Integer maxResults;

    private final String syncSessionToken;

    private ListRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identityId = builder.identityId;
        this.datasetName = builder.datasetName;
        this.lastSyncCount = builder.lastSyncCount;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.syncSessionToken = builder.syncSessionToken;
    }

    /**
     * A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID
     * generation is unique within a region.
     * 
     * @return A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
     *         Cognito. GUID generation is unique within a region.
     */
    public final String identityPoolId() {
        return identityPoolId;
    }

    /**
     * A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID
     * generation is unique within a region.
     * 
     * @return A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
     *         Cognito. GUID generation is unique within a region.
     */
    public final String identityId() {
        return identityId;
    }

    /**
     * A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.'
     * (dot).
     * 
     * @return A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and
     *         '.' (dot).
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * The last server sync count for this record.
     * 
     * @return The last server sync count for this record.
     */
    public final Long lastSyncCount() {
        return lastSyncCount;
    }

    /**
     * A pagination token for obtaining the next page of results.
     * 
     * @return A pagination token for obtaining the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * The maximum number of results to be returned.
     * 
     * @return The maximum number of results to be returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * A token containing a session ID, identity ID, and expiration.
     * 
     * @return A token containing a session ID, identity ID, and expiration.
     */
    public final String syncSessionToken() {
        return syncSessionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(identityId());
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(lastSyncCount());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(syncSessionToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecordsRequest)) {
            return false;
        }
        ListRecordsRequest other = (ListRecordsRequest) obj;
        return Objects.equals(identityPoolId(), other.identityPoolId()) && Objects.equals(identityId(), other.identityId())
                && Objects.equals(datasetName(), other.datasetName()) && Objects.equals(lastSyncCount(), other.lastSyncCount())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(syncSessionToken(), other.syncSessionToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRecordsRequest").add("IdentityPoolId", identityPoolId()).add("IdentityId", identityId())
                .add("DatasetName", datasetName()).add("LastSyncCount", lastSyncCount()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("SyncSessionToken", syncSessionToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPoolId":
            return Optional.ofNullable(clazz.cast(identityPoolId()));
        case "IdentityId":
            return Optional.ofNullable(clazz.cast(identityId()));
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "LastSyncCount":
            return Optional.ofNullable(clazz.cast(lastSyncCount()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "SyncSessionToken":
            return Optional.ofNullable(clazz.cast(syncSessionToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecordsRequest, T> g) {
        return obj -> g.apply((ListRecordsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListRecordsRequest> {
        /**
         * A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito.
         * GUID generation is unique within a region.
         * 
         * @param identityPoolId
         *        A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
         *        Cognito. GUID generation is unique within a region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito.
         * GUID generation is unique within a region.
         * 
         * @param identityId
         *        A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
         *        Cognito. GUID generation is unique within a region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.'
         * (dot).
         * 
         * @param datasetName
         *        A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash),
         *        and '.' (dot).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * The last server sync count for this record.
         * 
         * @param lastSyncCount
         *        The last server sync count for this record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSyncCount(Long lastSyncCount);

        /**
         * A pagination token for obtaining the next page of results.
         * 
         * @param nextToken
         *        A pagination token for obtaining the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * The maximum number of results to be returned.
         * 
         * @param maxResults
         *        The maximum number of results to be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * A token containing a session ID, identity ID, and expiration.
         * 
         * @param syncSessionToken
         *        A token containing a session ID, identity ID, and expiration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncSessionToken(String syncSessionToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoSyncRequest.BuilderImpl implements Builder {
        private String identityPoolId;

        private String identityId;

        private String datasetName;

        private Long lastSyncCount;

        private String nextToken;

        private Integer maxResults;

        private String syncSessionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecordsRequest model) {
            super(model);
            identityPoolId(model.identityPoolId);
            identityId(model.identityId);
            datasetName(model.datasetName);
            lastSyncCount(model.lastSyncCount);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            syncSessionToken(model.syncSessionToken);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getIdentityId() {
            return identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getDatasetName() {
            return datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final Long getLastSyncCount() {
            return lastSyncCount;
        }

        @Override
        public final Builder lastSyncCount(Long lastSyncCount) {
            this.lastSyncCount = lastSyncCount;
            return this;
        }

        public final void setLastSyncCount(Long lastSyncCount) {
            this.lastSyncCount = lastSyncCount;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getSyncSessionToken() {
            return syncSessionToken;
        }

        @Override
        public final Builder syncSessionToken(String syncSessionToken) {
            this.syncSessionToken = syncSessionToken;
            return this;
        }

        public final void setSyncSessionToken(String syncSessionToken) {
            this.syncSessionToken = syncSessionToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRecordsRequest build() {
            return new ListRecordsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
