/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Returned for a successful ListRecordsRequest.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecordsResponse extends CognitoSyncResponse implements
        ToCopyableBuilder<ListRecordsResponse.Builder, ListRecordsResponse> {
    private static final SdkField<List<Record>> RECORDS_FIELD = SdkField
            .<List<Record>> builder(MarshallingType.LIST)
            .getter(getter(ListRecordsResponse::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Record> builder(MarshallingType.SDK_POJO)
                                            .constructor(Record::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListRecordsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListRecordsResponse::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()).build();

    private static final SdkField<Long> DATASET_SYNC_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ListRecordsResponse::datasetSyncCount)).setter(setter(Builder::datasetSyncCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetSyncCount").build()).build();

    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListRecordsResponse::lastModifiedBy)).setter(setter(Builder::lastModifiedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<List<String>> MERGED_DATASET_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListRecordsResponse::mergedDatasetNames))
            .setter(setter(Builder::mergedDatasetNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergedDatasetNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DATASET_EXISTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ListRecordsResponse::datasetExists)).setter(setter(Builder::datasetExists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetExists").build()).build();

    private static final SdkField<Boolean> DATASET_DELETED_AFTER_REQUESTED_SYNC_COUNT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ListRecordsResponse::datasetDeletedAfterRequestedSyncCount))
            .setter(setter(Builder::datasetDeletedAfterRequestedSyncCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DatasetDeletedAfterRequestedSyncCount").build()).build();

    private static final SdkField<String> SYNC_SESSION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListRecordsResponse::syncSessionToken)).setter(setter(Builder::syncSessionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncSessionToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD,
            NEXT_TOKEN_FIELD, COUNT_FIELD, DATASET_SYNC_COUNT_FIELD, LAST_MODIFIED_BY_FIELD, MERGED_DATASET_NAMES_FIELD,
            DATASET_EXISTS_FIELD, DATASET_DELETED_AFTER_REQUESTED_SYNC_COUNT_FIELD, SYNC_SESSION_TOKEN_FIELD));

    private final List<Record> records;

    private final String nextToken;

    private final Integer count;

    private final Long datasetSyncCount;

    private final String lastModifiedBy;

    private final List<String> mergedDatasetNames;

    private final Boolean datasetExists;

    private final Boolean datasetDeletedAfterRequestedSyncCount;

    private final String syncSessionToken;

    private ListRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.records = builder.records;
        this.nextToken = builder.nextToken;
        this.count = builder.count;
        this.datasetSyncCount = builder.datasetSyncCount;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.mergedDatasetNames = builder.mergedDatasetNames;
        this.datasetExists = builder.datasetExists;
        this.datasetDeletedAfterRequestedSyncCount = builder.datasetDeletedAfterRequestedSyncCount;
        this.syncSessionToken = builder.syncSessionToken;
    }

    /**
     * Returns true if the Records property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * A list of all records.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of all records.
     */
    public List<Record> records() {
        return records;
    }

    /**
     * A pagination token for obtaining the next page of results.
     * 
     * @return A pagination token for obtaining the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Total number of records.
     * 
     * @return Total number of records.
     */
    public Integer count() {
        return count;
    }

    /**
     * Server sync count for this dataset.
     * 
     * @return Server sync count for this dataset.
     */
    public Long datasetSyncCount() {
        return datasetSyncCount;
    }

    /**
     * The user/device that made the last change to this record.
     * 
     * @return The user/device that made the last change to this record.
     */
    public String lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * Returns true if the MergedDatasetNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasMergedDatasetNames() {
        return mergedDatasetNames != null && !(mergedDatasetNames instanceof SdkAutoConstructList);
    }

    /**
     * Names of merged datasets.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMergedDatasetNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Names of merged datasets.
     */
    public List<String> mergedDatasetNames() {
        return mergedDatasetNames;
    }

    /**
     * Indicates whether the dataset exists.
     * 
     * @return Indicates whether the dataset exists.
     */
    public Boolean datasetExists() {
        return datasetExists;
    }

    /**
     * A boolean value specifying whether to delete the dataset locally.
     * 
     * @return A boolean value specifying whether to delete the dataset locally.
     */
    public Boolean datasetDeletedAfterRequestedSyncCount() {
        return datasetDeletedAfterRequestedSyncCount;
    }

    /**
     * A token containing a session ID, identity ID, and expiration.
     * 
     * @return A token containing a session ID, identity ID, and expiration.
     */
    public String syncSessionToken() {
        return syncSessionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(records());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(datasetSyncCount());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(mergedDatasetNames());
        hashCode = 31 * hashCode + Objects.hashCode(datasetExists());
        hashCode = 31 * hashCode + Objects.hashCode(datasetDeletedAfterRequestedSyncCount());
        hashCode = 31 * hashCode + Objects.hashCode(syncSessionToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecordsResponse)) {
            return false;
        }
        ListRecordsResponse other = (ListRecordsResponse) obj;
        return Objects.equals(records(), other.records()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(count(), other.count()) && Objects.equals(datasetSyncCount(), other.datasetSyncCount())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(mergedDatasetNames(), other.mergedDatasetNames())
                && Objects.equals(datasetExists(), other.datasetExists())
                && Objects.equals(datasetDeletedAfterRequestedSyncCount(), other.datasetDeletedAfterRequestedSyncCount())
                && Objects.equals(syncSessionToken(), other.syncSessionToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListRecordsResponse").add("Records", records()).add("NextToken", nextToken())
                .add("Count", count()).add("DatasetSyncCount", datasetSyncCount()).add("LastModifiedBy", lastModifiedBy())
                .add("MergedDatasetNames", mergedDatasetNames()).add("DatasetExists", datasetExists())
                .add("DatasetDeletedAfterRequestedSyncCount", datasetDeletedAfterRequestedSyncCount())
                .add("SyncSessionToken", syncSessionToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Records":
            return Optional.ofNullable(clazz.cast(records()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "DatasetSyncCount":
            return Optional.ofNullable(clazz.cast(datasetSyncCount()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "MergedDatasetNames":
            return Optional.ofNullable(clazz.cast(mergedDatasetNames()));
        case "DatasetExists":
            return Optional.ofNullable(clazz.cast(datasetExists()));
        case "DatasetDeletedAfterRequestedSyncCount":
            return Optional.ofNullable(clazz.cast(datasetDeletedAfterRequestedSyncCount()));
        case "SyncSessionToken":
            return Optional.ofNullable(clazz.cast(syncSessionToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecordsResponse, T> g) {
        return obj -> g.apply((ListRecordsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRecordsResponse> {
        /**
         * A list of all records.
         * 
         * @param records
         *        A list of all records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<Record> records);

        /**
         * A list of all records.
         * 
         * @param records
         *        A list of all records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Record... records);

        /**
         * A list of all records. This is a convenience that creates an instance of the {@link List<Record>.Builder}
         * avoiding the need to create one manually via {@link List<Record>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Record>.Builder#build()} is called immediately and its
         * result is passed to {@link #records(List<Record>)}.
         * 
         * @param records
         *        a consumer that will call methods on {@link List<Record>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #records(List<Record>)
         */
        Builder records(Consumer<Record.Builder>... records);

        /**
         * A pagination token for obtaining the next page of results.
         * 
         * @param nextToken
         *        A pagination token for obtaining the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Total number of records.
         * 
         * @param count
         *        Total number of records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * Server sync count for this dataset.
         * 
         * @param datasetSyncCount
         *        Server sync count for this dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetSyncCount(Long datasetSyncCount);

        /**
         * The user/device that made the last change to this record.
         * 
         * @param lastModifiedBy
         *        The user/device that made the last change to this record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(String lastModifiedBy);

        /**
         * Names of merged datasets.
         * 
         * @param mergedDatasetNames
         *        Names of merged datasets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergedDatasetNames(Collection<String> mergedDatasetNames);

        /**
         * Names of merged datasets.
         * 
         * @param mergedDatasetNames
         *        Names of merged datasets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergedDatasetNames(String... mergedDatasetNames);

        /**
         * Indicates whether the dataset exists.
         * 
         * @param datasetExists
         *        Indicates whether the dataset exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetExists(Boolean datasetExists);

        /**
         * A boolean value specifying whether to delete the dataset locally.
         * 
         * @param datasetDeletedAfterRequestedSyncCount
         *        A boolean value specifying whether to delete the dataset locally.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetDeletedAfterRequestedSyncCount(Boolean datasetDeletedAfterRequestedSyncCount);

        /**
         * A token containing a session ID, identity ID, and expiration.
         * 
         * @param syncSessionToken
         *        A token containing a session ID, identity ID, and expiration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncSessionToken(String syncSessionToken);
    }

    static final class BuilderImpl extends CognitoSyncResponse.BuilderImpl implements Builder {
        private List<Record> records = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer count;

        private Long datasetSyncCount;

        private String lastModifiedBy;

        private List<String> mergedDatasetNames = DefaultSdkAutoConstructList.getInstance();

        private Boolean datasetExists;

        private Boolean datasetDeletedAfterRequestedSyncCount;

        private String syncSessionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecordsResponse model) {
            super(model);
            records(model.records);
            nextToken(model.nextToken);
            count(model.count);
            datasetSyncCount(model.datasetSyncCount);
            lastModifiedBy(model.lastModifiedBy);
            mergedDatasetNames(model.mergedDatasetNames);
            datasetExists(model.datasetExists);
            datasetDeletedAfterRequestedSyncCount(model.datasetDeletedAfterRequestedSyncCount);
            syncSessionToken(model.syncSessionToken);
        }

        public final Collection<Record.Builder> getRecords() {
            return records != null ? records.stream().map(Record::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record... records) {
            records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<Record.Builder>... records) {
            records(Stream.of(records).map(c -> Record.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordListCopier.copyFromBuilder(records);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getCount() {
            return count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final Long getDatasetSyncCount() {
            return datasetSyncCount;
        }

        @Override
        public final Builder datasetSyncCount(Long datasetSyncCount) {
            this.datasetSyncCount = datasetSyncCount;
            return this;
        }

        public final void setDatasetSyncCount(Long datasetSyncCount) {
            this.datasetSyncCount = datasetSyncCount;
        }

        public final String getLastModifiedBy() {
            return lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        public final Collection<String> getMergedDatasetNames() {
            return mergedDatasetNames;
        }

        @Override
        public final Builder mergedDatasetNames(Collection<String> mergedDatasetNames) {
            this.mergedDatasetNames = MergedDatasetNameListCopier.copy(mergedDatasetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mergedDatasetNames(String... mergedDatasetNames) {
            mergedDatasetNames(Arrays.asList(mergedDatasetNames));
            return this;
        }

        public final void setMergedDatasetNames(Collection<String> mergedDatasetNames) {
            this.mergedDatasetNames = MergedDatasetNameListCopier.copy(mergedDatasetNames);
        }

        public final Boolean getDatasetExists() {
            return datasetExists;
        }

        @Override
        public final Builder datasetExists(Boolean datasetExists) {
            this.datasetExists = datasetExists;
            return this;
        }

        public final void setDatasetExists(Boolean datasetExists) {
            this.datasetExists = datasetExists;
        }

        public final Boolean getDatasetDeletedAfterRequestedSyncCount() {
            return datasetDeletedAfterRequestedSyncCount;
        }

        @Override
        public final Builder datasetDeletedAfterRequestedSyncCount(Boolean datasetDeletedAfterRequestedSyncCount) {
            this.datasetDeletedAfterRequestedSyncCount = datasetDeletedAfterRequestedSyncCount;
            return this;
        }

        public final void setDatasetDeletedAfterRequestedSyncCount(Boolean datasetDeletedAfterRequestedSyncCount) {
            this.datasetDeletedAfterRequestedSyncCount = datasetDeletedAfterRequestedSyncCount;
        }

        public final String getSyncSessionToken() {
            return syncSessionToken;
        }

        @Override
        public final Builder syncSessionToken(String syncSessionToken) {
            this.syncSessionToken = syncSessionToken;
            return this;
        }

        public final void setSyncSessionToken(String syncSessionToken) {
            this.syncSessionToken = syncSessionToken;
        }

        @Override
        public ListRecordsResponse build() {
            return new ListRecordsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
