/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitosync.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Usage information for the identity.
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityUsage implements SdkPojo, Serializable, ToCopyableBuilder<IdentityUsage.Builder, IdentityUsage> {
    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IdentityUsage::identityId)).setter(setter(Builder::identityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityId").build()).build();

    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IdentityUsage::identityPoolId)).setter(setter(Builder::identityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(IdentityUsage::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<Integer> DATASET_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(IdentityUsage::datasetCount)).setter(setter(Builder::datasetCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetCount").build()).build();

    private static final SdkField<Long> DATA_STORAGE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(IdentityUsage::dataStorage)).setter(setter(Builder::dataStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStorage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_ID_FIELD,
            IDENTITY_POOL_ID_FIELD, LAST_MODIFIED_DATE_FIELD, DATASET_COUNT_FIELD, DATA_STORAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String identityId;

    private final String identityPoolId;

    private final Instant lastModifiedDate;

    private final Integer datasetCount;

    private final Long dataStorage;

    private IdentityUsage(BuilderImpl builder) {
        this.identityId = builder.identityId;
        this.identityPoolId = builder.identityPoolId;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.datasetCount = builder.datasetCount;
        this.dataStorage = builder.dataStorage;
    }

    /**
     * A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID
     * generation is unique within a region.
     * 
     * @return A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
     *         Cognito. GUID generation is unique within a region.
     */
    public String identityId() {
        return identityId;
    }

    /**
     * A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID
     * generation is unique within a region.
     * 
     * @return A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
     *         Cognito. GUID generation is unique within a region.
     */
    public String identityPoolId() {
        return identityPoolId;
    }

    /**
     * Date on which the identity was last modified.
     * 
     * @return Date on which the identity was last modified.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * Number of datasets for the identity.
     * 
     * @return Number of datasets for the identity.
     */
    public Integer datasetCount() {
        return datasetCount;
    }

    /**
     * Total data storage for this identity.
     * 
     * @return Total data storage for this identity.
     */
    public Long dataStorage() {
        return dataStorage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityId());
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(datasetCount());
        hashCode = 31 * hashCode + Objects.hashCode(dataStorage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityUsage)) {
            return false;
        }
        IdentityUsage other = (IdentityUsage) obj;
        return Objects.equals(identityId(), other.identityId()) && Objects.equals(identityPoolId(), other.identityPoolId())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(datasetCount(), other.datasetCount()) && Objects.equals(dataStorage(), other.dataStorage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IdentityUsage").add("IdentityId", identityId()).add("IdentityPoolId", identityPoolId())
                .add("LastModifiedDate", lastModifiedDate()).add("DatasetCount", datasetCount())
                .add("DataStorage", dataStorage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityId":
            return Optional.ofNullable(clazz.cast(identityId()));
        case "IdentityPoolId":
            return Optional.ofNullable(clazz.cast(identityPoolId()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "DatasetCount":
            return Optional.ofNullable(clazz.cast(datasetCount()));
        case "DataStorage":
            return Optional.ofNullable(clazz.cast(dataStorage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityUsage, T> g) {
        return obj -> g.apply((IdentityUsage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityUsage> {
        /**
         * A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito.
         * GUID generation is unique within a region.
         * 
         * @param identityId
         *        A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
         *        Cognito. GUID generation is unique within a region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito.
         * GUID generation is unique within a region.
         * 
         * @param identityPoolId
         *        A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
         *        Cognito. GUID generation is unique within a region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * Date on which the identity was last modified.
         * 
         * @param lastModifiedDate
         *        Date on which the identity was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * Number of datasets for the identity.
         * 
         * @param datasetCount
         *        Number of datasets for the identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetCount(Integer datasetCount);

        /**
         * Total data storage for this identity.
         * 
         * @param dataStorage
         *        Total data storage for this identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataStorage(Long dataStorage);
    }

    static final class BuilderImpl implements Builder {
        private String identityId;

        private String identityPoolId;

        private Instant lastModifiedDate;

        private Integer datasetCount;

        private Long dataStorage;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityUsage model) {
            identityId(model.identityId);
            identityPoolId(model.identityPoolId);
            lastModifiedDate(model.lastModifiedDate);
            datasetCount(model.datasetCount);
            dataStorage(model.dataStorage);
        }

        public final String getIdentityId() {
            return identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Integer getDatasetCount() {
            return datasetCount;
        }

        @Override
        public final Builder datasetCount(Integer datasetCount) {
            this.datasetCount = datasetCount;
            return this;
        }

        public final void setDatasetCount(Integer datasetCount) {
            this.datasetCount = datasetCount;
        }

        public final Long getDataStorage() {
            return dataStorage;
        }

        @Override
        public final Builder dataStorage(Long dataStorage) {
            this.dataStorage = dataStorage;
            return this;
        }

        public final void setDataStorage(Long dataStorage) {
            this.dataStorage = dataStorage;
        }

        @Override
        public IdentityUsage build() {
            return new IdentityUsage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
