/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitosync.transform.IdentityPoolUsageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IdentityPoolUsage
implements StructuredPojo,
ToCopyableBuilder<Builder, IdentityPoolUsage> {
    private final String identityPoolId;
    private final Long syncSessionsCount;
    private final Long dataStorage;
    private final Instant lastModifiedDate;

    private IdentityPoolUsage(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.syncSessionsCount = builder.syncSessionsCount;
        this.dataStorage = builder.dataStorage;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public Long syncSessionsCount() {
        return this.syncSessionsCount;
    }

    public Long dataStorage() {
        return this.dataStorage;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncSessionsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityPoolUsage)) {
            return false;
        }
        IdentityPoolUsage other = (IdentityPoolUsage)obj;
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.syncSessionsCount(), other.syncSessionsCount()) && Objects.equals(this.dataStorage(), other.dataStorage()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        if (this.syncSessionsCount() != null) {
            sb.append("SyncSessionsCount: ").append(this.syncSessionsCount()).append(",");
        }
        if (this.dataStorage() != null) {
            sb.append("DataStorage: ").append(this.dataStorage()).append(",");
        }
        if (this.lastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.lastModifiedDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.of(clazz.cast(this.identityPoolId()));
            }
            case "SyncSessionsCount": {
                return Optional.of(clazz.cast(this.syncSessionsCount()));
            }
            case "DataStorage": {
                return Optional.of(clazz.cast(this.dataStorage()));
            }
            case "LastModifiedDate": {
                return Optional.of(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IdentityPoolUsageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String identityPoolId;
        private Long syncSessionsCount;
        private Long dataStorage;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityPoolUsage model) {
            this.identityPoolId(model.identityPoolId);
            this.syncSessionsCount(model.syncSessionsCount);
            this.dataStorage(model.dataStorage);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Long getSyncSessionsCount() {
            return this.syncSessionsCount;
        }

        @Override
        public final Builder syncSessionsCount(Long syncSessionsCount) {
            this.syncSessionsCount = syncSessionsCount;
            return this;
        }

        public final void setSyncSessionsCount(Long syncSessionsCount) {
            this.syncSessionsCount = syncSessionsCount;
        }

        public final Long getDataStorage() {
            return this.dataStorage;
        }

        @Override
        public final Builder dataStorage(Long dataStorage) {
            this.dataStorage = dataStorage;
            return this;
        }

        public final void setDataStorage(Long dataStorage) {
            this.dataStorage = dataStorage;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public IdentityPoolUsage build() {
            return new IdentityPoolUsage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IdentityPoolUsage> {
        public Builder identityPoolId(String var1);

        public Builder syncSessionsCount(Long var1);

        public Builder dataStorage(Long var1);

        public Builder lastModifiedDate(Instant var1);
    }
}

