/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitosync.transform.IdentityUsageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IdentityUsage
implements StructuredPojo,
ToCopyableBuilder<Builder, IdentityUsage> {
    private final String identityId;
    private final String identityPoolId;
    private final Instant lastModifiedDate;
    private final Integer datasetCount;
    private final Long dataStorage;

    private IdentityUsage(BuilderImpl builder) {
        this.identityId = builder.identityId;
        this.identityPoolId = builder.identityPoolId;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.datasetCount = builder.datasetCount;
        this.dataStorage = builder.dataStorage;
    }

    public String identityId() {
        return this.identityId;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Integer datasetCount() {
        return this.datasetCount;
    }

    public Long dataStorage() {
        return this.dataStorage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityId() == null ? 0 : this.identityId().hashCode());
        hashCode = 31 * hashCode + (this.identityPoolId() == null ? 0 : this.identityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.lastModifiedDate() == null ? 0 : this.lastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.datasetCount() == null ? 0 : this.datasetCount().hashCode());
        hashCode = 31 * hashCode + (this.dataStorage() == null ? 0 : this.dataStorage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityUsage)) {
            return false;
        }
        IdentityUsage other = (IdentityUsage)obj;
        if (other.identityId() == null ^ this.identityId() == null) {
            return false;
        }
        if (other.identityId() != null && !other.identityId().equals(this.identityId())) {
            return false;
        }
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        if (other.lastModifiedDate() == null ^ this.lastModifiedDate() == null) {
            return false;
        }
        if (other.lastModifiedDate() != null && !other.lastModifiedDate().equals(this.lastModifiedDate())) {
            return false;
        }
        if (other.datasetCount() == null ^ this.datasetCount() == null) {
            return false;
        }
        if (other.datasetCount() != null && !other.datasetCount().equals(this.datasetCount())) {
            return false;
        }
        if (other.dataStorage() == null ^ this.dataStorage() == null) {
            return false;
        }
        return other.dataStorage() == null || other.dataStorage().equals(this.dataStorage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityId() != null) {
            sb.append("IdentityId: ").append(this.identityId()).append(",");
        }
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        if (this.lastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.lastModifiedDate()).append(",");
        }
        if (this.datasetCount() != null) {
            sb.append("DatasetCount: ").append(this.datasetCount()).append(",");
        }
        if (this.dataStorage() != null) {
            sb.append("DataStorage: ").append(this.dataStorage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityId": {
                return Optional.of(clazz.cast(this.identityId()));
            }
            case "IdentityPoolId": {
                return Optional.of(clazz.cast(this.identityPoolId()));
            }
            case "LastModifiedDate": {
                return Optional.of(clazz.cast(this.lastModifiedDate()));
            }
            case "DatasetCount": {
                return Optional.of(clazz.cast(this.datasetCount()));
            }
            case "DataStorage": {
                return Optional.of(clazz.cast(this.dataStorage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IdentityUsageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String identityId;
        private String identityPoolId;
        private Instant lastModifiedDate;
        private Integer datasetCount;
        private Long dataStorage;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityUsage model) {
            this.identityId(model.identityId);
            this.identityPoolId(model.identityPoolId);
            this.lastModifiedDate(model.lastModifiedDate);
            this.datasetCount(model.datasetCount);
            this.dataStorage(model.dataStorage);
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Integer getDatasetCount() {
            return this.datasetCount;
        }

        @Override
        public final Builder datasetCount(Integer datasetCount) {
            this.datasetCount = datasetCount;
            return this;
        }

        public final void setDatasetCount(Integer datasetCount) {
            this.datasetCount = datasetCount;
        }

        public final Long getDataStorage() {
            return this.dataStorage;
        }

        @Override
        public final Builder dataStorage(Long dataStorage) {
            this.dataStorage = dataStorage;
            return this;
        }

        public final void setDataStorage(Long dataStorage) {
            this.dataStorage = dataStorage;
        }

        public IdentityUsage build() {
            return new IdentityUsage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IdentityUsage> {
        public Builder identityId(String var1);

        public Builder identityPoolId(String var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder datasetCount(Integer var1);

        public Builder dataStorage(Long var1);
    }
}

