/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cognitosync.CognitoSyncClient;
import software.amazon.awssdk.services.cognitosync.model.AlreadyStreamedException;
import software.amazon.awssdk.services.cognitosync.model.BulkPublishRequest;
import software.amazon.awssdk.services.cognitosync.model.BulkPublishResponse;
import software.amazon.awssdk.services.cognitosync.model.CognitoSyncException;
import software.amazon.awssdk.services.cognitosync.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cognitosync.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.cognitosync.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.cognitosync.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.cognitosync.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageRequest;
import software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageResponse;
import software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageRequest;
import software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageResponse;
import software.amazon.awssdk.services.cognitosync.model.DuplicateRequestException;
import software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsRequest;
import software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsResponse;
import software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsRequest;
import software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsResponse;
import software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationRequest;
import software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationResponse;
import software.amazon.awssdk.services.cognitosync.model.InternalErrorException;
import software.amazon.awssdk.services.cognitosync.model.InvalidConfigurationException;
import software.amazon.awssdk.services.cognitosync.model.InvalidLambdaFunctionOutputException;
import software.amazon.awssdk.services.cognitosync.model.InvalidParameterException;
import software.amazon.awssdk.services.cognitosync.model.LambdaThrottledException;
import software.amazon.awssdk.services.cognitosync.model.LimitExceededException;
import software.amazon.awssdk.services.cognitosync.model.ListDatasetsRequest;
import software.amazon.awssdk.services.cognitosync.model.ListDatasetsResponse;
import software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageRequest;
import software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageResponse;
import software.amazon.awssdk.services.cognitosync.model.ListRecordsRequest;
import software.amazon.awssdk.services.cognitosync.model.ListRecordsResponse;
import software.amazon.awssdk.services.cognitosync.model.NotAuthorizedException;
import software.amazon.awssdk.services.cognitosync.model.RegisterDeviceRequest;
import software.amazon.awssdk.services.cognitosync.model.RegisterDeviceResponse;
import software.amazon.awssdk.services.cognitosync.model.ResourceConflictException;
import software.amazon.awssdk.services.cognitosync.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cognitosync.model.SetCognitoEventsRequest;
import software.amazon.awssdk.services.cognitosync.model.SetCognitoEventsResponse;
import software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationRequest;
import software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationResponse;
import software.amazon.awssdk.services.cognitosync.model.SubscribeToDatasetRequest;
import software.amazon.awssdk.services.cognitosync.model.SubscribeToDatasetResponse;
import software.amazon.awssdk.services.cognitosync.model.TooManyRequestsException;
import software.amazon.awssdk.services.cognitosync.model.UnsubscribeFromDatasetRequest;
import software.amazon.awssdk.services.cognitosync.model.UnsubscribeFromDatasetResponse;
import software.amazon.awssdk.services.cognitosync.model.UpdateRecordsRequest;
import software.amazon.awssdk.services.cognitosync.model.UpdateRecordsResponse;
import software.amazon.awssdk.services.cognitosync.transform.BulkPublishRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.BulkPublishResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DeleteDatasetRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DeleteDatasetResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DescribeDatasetRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DescribeDatasetResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DescribeIdentityPoolUsageRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DescribeIdentityPoolUsageResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DescribeIdentityUsageRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DescribeIdentityUsageResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.GetBulkPublishDetailsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.GetBulkPublishDetailsResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.GetCognitoEventsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.GetCognitoEventsResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.GetIdentityPoolConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.GetIdentityPoolConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.ListDatasetsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.ListDatasetsResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.ListIdentityPoolUsageRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.ListIdentityPoolUsageResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.ListRecordsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.ListRecordsResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.RegisterDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.RegisterDeviceResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.SetCognitoEventsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.SetCognitoEventsResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.SetIdentityPoolConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.SetIdentityPoolConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.SubscribeToDatasetRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.SubscribeToDatasetResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.UnsubscribeFromDatasetRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.UnsubscribeFromDatasetResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.UpdateRecordsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.UpdateRecordsResponseUnmarshaller;

@SdkInternalApi
final class DefaultCognitoSyncClient
implements CognitoSyncClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final AwsSyncClientParams clientParams;

    protected DefaultCognitoSyncClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = this.init();
    }

    @Override
    public BulkPublishResponse bulkPublish(BulkPublishRequest bulkPublishRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, DuplicateRequestException, AlreadyStreamedException, SdkBaseException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new BulkPublishResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (BulkPublishResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)bulkPublishRequest).withMarshaller((Marshaller)new BulkPublishRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteDatasetResponse deleteDataset(DeleteDatasetRequest deleteDatasetRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, TooManyRequestsException, ResourceConflictException, SdkBaseException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteDatasetResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteDatasetResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteDatasetRequest).withMarshaller((Marshaller)new DeleteDatasetRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeDatasetResponse describeDataset(DescribeDatasetRequest describeDatasetRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, TooManyRequestsException, SdkBaseException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeDatasetResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeDatasetResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeDatasetRequest).withMarshaller((Marshaller)new DescribeDatasetRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeIdentityPoolUsageResponse describeIdentityPoolUsage(DescribeIdentityPoolUsageRequest describeIdentityPoolUsageRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, TooManyRequestsException, SdkBaseException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeIdentityPoolUsageResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeIdentityPoolUsageResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeIdentityPoolUsageRequest).withMarshaller((Marshaller)new DescribeIdentityPoolUsageRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeIdentityUsageResponse describeIdentityUsage(DescribeIdentityUsageRequest describeIdentityUsageRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, TooManyRequestsException, SdkBaseException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeIdentityUsageResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeIdentityUsageResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeIdentityUsageRequest).withMarshaller((Marshaller)new DescribeIdentityUsageRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetBulkPublishDetailsResponse getBulkPublishDetails(GetBulkPublishDetailsRequest getBulkPublishDetailsRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, SdkBaseException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetBulkPublishDetailsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetBulkPublishDetailsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getBulkPublishDetailsRequest).withMarshaller((Marshaller)new GetBulkPublishDetailsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetCognitoEventsResponse getCognitoEvents(GetCognitoEventsRequest getCognitoEventsRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, InternalErrorException, TooManyRequestsException, SdkBaseException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetCognitoEventsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetCognitoEventsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getCognitoEventsRequest).withMarshaller((Marshaller)new GetCognitoEventsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetIdentityPoolConfigurationResponse getIdentityPoolConfiguration(GetIdentityPoolConfigurationRequest getIdentityPoolConfigurationRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, TooManyRequestsException, SdkBaseException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetIdentityPoolConfigurationResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetIdentityPoolConfigurationResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getIdentityPoolConfigurationRequest).withMarshaller((Marshaller)new GetIdentityPoolConfigurationRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListDatasetsResponse listDatasets(ListDatasetsRequest listDatasetsRequest) throws NotAuthorizedException, InvalidParameterException, InternalErrorException, TooManyRequestsException, SdkBaseException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListDatasetsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListDatasetsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listDatasetsRequest).withMarshaller((Marshaller)new ListDatasetsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListIdentityPoolUsageResponse listIdentityPoolUsage() throws NotAuthorizedException, InvalidParameterException, InternalErrorException, TooManyRequestsException, SdkBaseException, SdkClientException, CognitoSyncException {
        return this.listIdentityPoolUsage((ListIdentityPoolUsageRequest)((Object)ListIdentityPoolUsageRequest.builder().build()));
    }

    @Override
    public ListIdentityPoolUsageResponse listIdentityPoolUsage(ListIdentityPoolUsageRequest listIdentityPoolUsageRequest) throws NotAuthorizedException, InvalidParameterException, InternalErrorException, TooManyRequestsException, SdkBaseException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListIdentityPoolUsageResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListIdentityPoolUsageResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listIdentityPoolUsageRequest).withMarshaller((Marshaller)new ListIdentityPoolUsageRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListRecordsResponse listRecords(ListRecordsRequest listRecordsRequest) throws InvalidParameterException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, SdkBaseException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListRecordsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListRecordsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listRecordsRequest).withMarshaller((Marshaller)new ListRecordsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public RegisterDeviceResponse registerDevice(RegisterDeviceRequest registerDeviceRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, InvalidConfigurationException, TooManyRequestsException, SdkBaseException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new RegisterDeviceResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RegisterDeviceResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)registerDeviceRequest).withMarshaller((Marshaller)new RegisterDeviceRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public SetCognitoEventsResponse setCognitoEvents(SetCognitoEventsRequest setCognitoEventsRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, InternalErrorException, TooManyRequestsException, SdkBaseException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new SetCognitoEventsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (SetCognitoEventsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)setCognitoEventsRequest).withMarshaller((Marshaller)new SetCognitoEventsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public SetIdentityPoolConfigurationResponse setIdentityPoolConfiguration(SetIdentityPoolConfigurationRequest setIdentityPoolConfigurationRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, TooManyRequestsException, ConcurrentModificationException, SdkBaseException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new SetIdentityPoolConfigurationResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (SetIdentityPoolConfigurationResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)setIdentityPoolConfigurationRequest).withMarshaller((Marshaller)new SetIdentityPoolConfigurationRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public SubscribeToDatasetResponse subscribeToDataset(SubscribeToDatasetRequest subscribeToDatasetRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, InvalidConfigurationException, TooManyRequestsException, SdkBaseException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new SubscribeToDatasetResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (SubscribeToDatasetResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)subscribeToDatasetRequest).withMarshaller((Marshaller)new SubscribeToDatasetRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UnsubscribeFromDatasetResponse unsubscribeFromDataset(UnsubscribeFromDatasetRequest unsubscribeFromDatasetRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, InvalidConfigurationException, TooManyRequestsException, SdkBaseException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UnsubscribeFromDatasetResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UnsubscribeFromDatasetResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)unsubscribeFromDatasetRequest).withMarshaller((Marshaller)new UnsubscribeFromDatasetRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateRecordsResponse updateRecords(UpdateRecordsRequest updateRecordsRequest) throws InvalidParameterException, LimitExceededException, NotAuthorizedException, ResourceNotFoundException, ResourceConflictException, InvalidLambdaFunctionOutputException, LambdaThrottledException, TooManyRequestsException, InternalErrorException, SdkBaseException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateRecordsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateRecordsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateRecordsRequest).withMarshaller((Marshaller)new UpdateRecordsRequestMarshaller(this.protocolFactory))));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(CognitoSyncException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModification").withModeledClass(ConcurrentModificationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidConfiguration").withModeledClass(InvalidConfigurationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameter").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFound").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateRequest").withModeledClass(DuplicateRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceConflict").withModeledClass(ResourceConflictException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LambdaThrottled").withModeledClass(LambdaThrottledException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotAuthorizedError").withModeledClass(NotAuthorizedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalError").withModeledClass(InternalErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequests").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidLambdaFunctionOutput").withModeledClass(InvalidLambdaFunctionOutputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceeded").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AlreadyStreamed").withModeledClass(AlreadyStreamedException.class)));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }
}

