/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitosync.model.IdentityUsage;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class IdentityUsageMarshaller {
    private static final MarshallingInfo<String> IDENTITYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityId").isBinary(false).build();
    private static final MarshallingInfo<String> IDENTITYPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityPoolId").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedDate").isBinary(false).build();
    private static final MarshallingInfo<Integer> DATASETCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatasetCount").isBinary(false).build();
    private static final MarshallingInfo<Long> DATASTORAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataStorage").isBinary(false).build();
    private static final IdentityUsageMarshaller INSTANCE = new IdentityUsageMarshaller();

    private IdentityUsageMarshaller() {
    }

    public static IdentityUsageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(IdentityUsage identityUsage, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)identityUsage, (String)"identityUsage");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)identityUsage.identityId(), IDENTITYID_BINDING);
            protocolMarshaller.marshall((Object)identityUsage.identityPoolId(), IDENTITYPOOLID_BINDING);
            protocolMarshaller.marshall((Object)identityUsage.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall((Object)identityUsage.datasetCount(), DATASETCOUNT_BINDING);
            protocolMarshaller.marshall((Object)identityUsage.dataStorage(), DATASTORAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

