/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitosync.model.ApplicationArnListCopier;
import software.amazon.awssdk.services.cognitosync.transform.PushSyncMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PushSync
implements StructuredPojo,
ToCopyableBuilder<Builder, PushSync> {
    private final List<String> applicationArns;
    private final String roleArn;

    private PushSync(BuilderImpl builder) {
        this.applicationArns = builder.applicationArns;
        this.roleArn = builder.roleArn;
    }

    public List<String> applicationArns() {
        return this.applicationArns;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PushSync)) {
            return false;
        }
        PushSync other = (PushSync)obj;
        return Objects.equals(this.applicationArns(), other.applicationArns()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"PushSync").add("ApplicationArns", this.applicationArns()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationArns": {
                return Optional.of(clazz.cast(this.applicationArns()));
            }
            case "RoleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PushSyncMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> applicationArns;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PushSync model) {
            this.applicationArns(model.applicationArns);
            this.roleArn(model.roleArn);
        }

        public final Collection<String> getApplicationArns() {
            return this.applicationArns;
        }

        @Override
        public final Builder applicationArns(Collection<String> applicationArns) {
            this.applicationArns = ApplicationArnListCopier.copy(applicationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationArns(String ... applicationArns) {
            this.applicationArns(Arrays.asList(applicationArns));
            return this;
        }

        public final void setApplicationArns(Collection<String> applicationArns) {
            this.applicationArns = ApplicationArnListCopier.copy(applicationArns);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public PushSync build() {
            return new PushSync(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PushSync> {
        public Builder applicationArns(Collection<String> var1);

        public Builder applicationArns(String ... var1);

        public Builder roleArn(String var1);
    }
}

