/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.transform;

import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitosync.model.RecordPatch;

@SdkInternalApi
public class RecordPatchMarshaller {
    private static final MarshallingInfo<String> OP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Op").build();
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MarshallingInfo<Long> SYNCCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SyncCount").build();
    private static final MarshallingInfo<Date> DEVICELASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceLastModifiedDate").build();
    private static final RecordPatchMarshaller instance = new RecordPatchMarshaller();

    public static RecordPatchMarshaller getInstance() {
        return instance;
    }

    public void marshall(RecordPatch recordPatch, ProtocolMarshaller protocolMarshaller) {
        if (recordPatch == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)recordPatch.op(), OP_BINDING);
            protocolMarshaller.marshall((Object)recordPatch.key(), KEY_BINDING);
            protocolMarshaller.marshall((Object)recordPatch.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)recordPatch.syncCount(), SYNCCOUNT_BINDING);
            protocolMarshaller.marshall((Object)recordPatch.deviceLastModifiedDate(), DEVICELASTMODIFIEDDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

