/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.cognitosync.transform.DatasetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Dataset
implements StructuredPojo,
ToCopyableBuilder<Builder, Dataset> {
    private final String identityId;
    private final String datasetName;
    private final Date creationDate;
    private final Date lastModifiedDate;
    private final String lastModifiedBy;
    private final Long dataStorage;
    private final Long numRecords;

    private Dataset(BuilderImpl builder) {
        this.identityId = builder.identityId;
        this.datasetName = builder.datasetName;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.dataStorage = builder.dataStorage;
        this.numRecords = builder.numRecords;
    }

    public String identityId() {
        return this.identityId;
    }

    public String datasetName() {
        return this.datasetName;
    }

    public Date creationDate() {
        return this.creationDate;
    }

    public Date lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public Long dataStorage() {
        return this.dataStorage;
    }

    public Long numRecords() {
        return this.numRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityId() == null ? 0 : this.identityId().hashCode());
        hashCode = 31 * hashCode + (this.datasetName() == null ? 0 : this.datasetName().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        hashCode = 31 * hashCode + (this.lastModifiedDate() == null ? 0 : this.lastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.lastModifiedBy() == null ? 0 : this.lastModifiedBy().hashCode());
        hashCode = 31 * hashCode + (this.dataStorage() == null ? 0 : this.dataStorage().hashCode());
        hashCode = 31 * hashCode + (this.numRecords() == null ? 0 : this.numRecords().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dataset)) {
            return false;
        }
        Dataset other = (Dataset)obj;
        if (other.identityId() == null ^ this.identityId() == null) {
            return false;
        }
        if (other.identityId() != null && !other.identityId().equals(this.identityId())) {
            return false;
        }
        if (other.datasetName() == null ^ this.datasetName() == null) {
            return false;
        }
        if (other.datasetName() != null && !other.datasetName().equals(this.datasetName())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.lastModifiedDate() == null ^ this.lastModifiedDate() == null) {
            return false;
        }
        if (other.lastModifiedDate() != null && !other.lastModifiedDate().equals(this.lastModifiedDate())) {
            return false;
        }
        if (other.lastModifiedBy() == null ^ this.lastModifiedBy() == null) {
            return false;
        }
        if (other.lastModifiedBy() != null && !other.lastModifiedBy().equals(this.lastModifiedBy())) {
            return false;
        }
        if (other.dataStorage() == null ^ this.dataStorage() == null) {
            return false;
        }
        if (other.dataStorage() != null && !other.dataStorage().equals(this.dataStorage())) {
            return false;
        }
        if (other.numRecords() == null ^ this.numRecords() == null) {
            return false;
        }
        return other.numRecords() == null || other.numRecords().equals(this.numRecords());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.identityId() != null) {
            sb.append("IdentityId: ").append(this.identityId()).append(",");
        }
        if (this.datasetName() != null) {
            sb.append("DatasetName: ").append(this.datasetName()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.lastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.lastModifiedDate()).append(",");
        }
        if (this.lastModifiedBy() != null) {
            sb.append("LastModifiedBy: ").append(this.lastModifiedBy()).append(",");
        }
        if (this.dataStorage() != null) {
            sb.append("DataStorage: ").append(this.dataStorage()).append(",");
        }
        if (this.numRecords() != null) {
            sb.append("NumRecords: ").append(this.numRecords()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DatasetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String identityId;
        private String datasetName;
        private Date creationDate;
        private Date lastModifiedDate;
        private String lastModifiedBy;
        private Long dataStorage;
        private Long numRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(Dataset model) {
            this.setIdentityId(model.identityId);
            this.setDatasetName(model.datasetName);
            this.setCreationDate(model.creationDate);
            this.setLastModifiedDate(model.lastModifiedDate);
            this.setLastModifiedBy(model.lastModifiedBy);
            this.setDataStorage(model.dataStorage);
            this.setNumRecords(model.numRecords);
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final Date getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Date creationDate) {
            this.creationDate = StandardMemberCopier.copy((Date)creationDate);
            return this;
        }

        public final void setCreationDate(Date creationDate) {
            this.creationDate = StandardMemberCopier.copy((Date)creationDate);
        }

        public final Date getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = StandardMemberCopier.copy((Date)lastModifiedDate);
            return this;
        }

        public final void setLastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = StandardMemberCopier.copy((Date)lastModifiedDate);
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        public final Long getDataStorage() {
            return this.dataStorage;
        }

        @Override
        public final Builder dataStorage(Long dataStorage) {
            this.dataStorage = dataStorage;
            return this;
        }

        public final void setDataStorage(Long dataStorage) {
            this.dataStorage = dataStorage;
        }

        public final Long getNumRecords() {
            return this.numRecords;
        }

        @Override
        public final Builder numRecords(Long numRecords) {
            this.numRecords = numRecords;
            return this;
        }

        public final void setNumRecords(Long numRecords) {
            this.numRecords = numRecords;
        }

        public Dataset build() {
            return new Dataset(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Dataset> {
        public Builder identityId(String var1);

        public Builder datasetName(String var1);

        public Builder creationDate(Date var1);

        public Builder lastModifiedDate(Date var1);

        public Builder lastModifiedBy(String var1);

        public Builder dataStorage(Long var1);

        public Builder numRecords(Long var1);
    }
}

