/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarnotifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Amazon Q Developer in chat applications topics or Amazon Q Developer in chat applications
 * clients associated with a notification rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Target implements SdkPojo, Serializable, ToCopyableBuilder<Target.Builder, Target> {
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetType").getter(getter(Target::targetType)).setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()).build();

    private static final SdkField<String> TARGET_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetAddress").getter(getter(Target::targetAddress)).setter(setter(Builder::targetAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_TYPE_FIELD,
            TARGET_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String targetType;

    private final String targetAddress;

    private Target(BuilderImpl builder) {
        this.targetType = builder.targetType;
        this.targetAddress = builder.targetAddress;
    }

    /**
     * <p>
     * The target type. Can be an Amazon Q Developer in chat applications topic or Amazon Q Developer in chat
     * applications client.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Q Developer in chat applications topics are specified as <code>SNS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Q Developer in chat applications clients are specified as <code>AWSChatbotSlack</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The target type. Can be an Amazon Q Developer in chat applications topic or Amazon Q Developer in chat
     *         applications client.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Amazon Q Developer in chat applications topics are specified as <code>SNS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Q Developer in chat applications clients are specified as <code>AWSChatbotSlack</code>.
     *         </p>
     *         </li>
     */
    public final String targetType() {
        return targetType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Q Developer in chat applications topic or Amazon Q Developer in chat
     * applications client.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Q Developer in chat applications topic or Amazon Q Developer
     *         in chat applications client.
     */
    public final String targetAddress() {
        return targetAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetType());
        hashCode = 31 * hashCode + Objects.hashCode(targetAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Target)) {
            return false;
        }
        Target other = (Target) obj;
        return Objects.equals(targetType(), other.targetType()) && Objects.equals(targetAddress(), other.targetAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Target").add("TargetType", targetType())
                .add("TargetAddress", targetAddress() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetType":
            return Optional.ofNullable(clazz.cast(targetType()));
        case "TargetAddress":
            return Optional.ofNullable(clazz.cast(targetAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetType", TARGET_TYPE_FIELD);
        map.put("TargetAddress", TARGET_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Target, T> g) {
        return obj -> g.apply((Target) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Target> {
        /**
         * <p>
         * The target type. Can be an Amazon Q Developer in chat applications topic or Amazon Q Developer in chat
         * applications client.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Amazon Q Developer in chat applications topics are specified as <code>SNS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Q Developer in chat applications clients are specified as <code>AWSChatbotSlack</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetType
         *        The target type. Can be an Amazon Q Developer in chat applications topic or Amazon Q Developer in chat
         *        applications client.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Amazon Q Developer in chat applications topics are specified as <code>SNS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Q Developer in chat applications clients are specified as <code>AWSChatbotSlack</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Q Developer in chat applications topic or Amazon Q Developer in
         * chat applications client.
         * </p>
         * 
         * @param targetAddress
         *        The Amazon Resource Name (ARN) of the Amazon Q Developer in chat applications topic or Amazon Q
         *        Developer in chat applications client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAddress(String targetAddress);
    }

    static final class BuilderImpl implements Builder {
        private String targetType;

        private String targetAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(Target model) {
            targetType(model.targetType);
            targetAddress(model.targetAddress);
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        public final String getTargetAddress() {
            return targetAddress;
        }

        public final void setTargetAddress(String targetAddress) {
            this.targetAddress = targetAddress;
        }

        @Override
        public final Builder targetAddress(String targetAddress) {
            this.targetAddress = targetAddress;
            return this;
        }

        @Override
        public Target build() {
            return new Target(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
