/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarnotifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNotificationRulesResponse extends CodestarNotificationsResponse implements
        ToCopyableBuilder<ListNotificationRulesResponse.Builder, ListNotificationRulesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListNotificationRulesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<NotificationRuleSummary>> NOTIFICATION_RULES_FIELD = SdkField
            .<List<NotificationRuleSummary>> builder(MarshallingType.LIST)
            .memberName("NotificationRules")
            .getter(getter(ListNotificationRulesResponse::notificationRules))
            .setter(setter(Builder::notificationRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotificationRuleSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotificationRuleSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            NOTIFICATION_RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<NotificationRuleSummary> notificationRules;

    private ListNotificationRulesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.notificationRules = builder.notificationRules;
    }

    /**
     * <p>
     * An enumeration token that can be used in a request to return the next batch of the results.
     * </p>
     * 
     * @return An enumeration token that can be used in a request to return the next batch of the results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotificationRules property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNotificationRules() {
        return notificationRules != null && !(notificationRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of notification rules for the Amazon Web Services account, by Amazon Resource Name (ARN) and ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotificationRules} method.
     * </p>
     * 
     * @return The list of notification rules for the Amazon Web Services account, by Amazon Resource Name (ARN) and ID.
     */
    public final List<NotificationRuleSummary> notificationRules() {
        return notificationRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasNotificationRules() ? notificationRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationRulesResponse)) {
            return false;
        }
        ListNotificationRulesResponse other = (ListNotificationRulesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasNotificationRules() == other.hasNotificationRules()
                && Objects.equals(notificationRules(), other.notificationRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNotificationRulesResponse").add("NextToken", nextToken())
                .add("NotificationRules", hasNotificationRules() ? notificationRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "NotificationRules":
            return Optional.ofNullable(clazz.cast(notificationRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("NotificationRules", NOTIFICATION_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNotificationRulesResponse, T> g) {
        return obj -> g.apply((ListNotificationRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodestarNotificationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListNotificationRulesResponse> {
        /**
         * <p>
         * An enumeration token that can be used in a request to return the next batch of the results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that can be used in a request to return the next batch of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of notification rules for the Amazon Web Services account, by Amazon Resource Name (ARN) and ID.
         * </p>
         * 
         * @param notificationRules
         *        The list of notification rules for the Amazon Web Services account, by Amazon Resource Name (ARN) and
         *        ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationRules(Collection<NotificationRuleSummary> notificationRules);

        /**
         * <p>
         * The list of notification rules for the Amazon Web Services account, by Amazon Resource Name (ARN) and ID.
         * </p>
         * 
         * @param notificationRules
         *        The list of notification rules for the Amazon Web Services account, by Amazon Resource Name (ARN) and
         *        ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationRules(NotificationRuleSummary... notificationRules);

        /**
         * <p>
         * The list of notification rules for the Amazon Web Services account, by Amazon Resource Name (ARN) and ID.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleSummary.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleSummary.Builder#build()}
         * is called immediately and its result is passed to {@link #notificationRules(List<NotificationRuleSummary>)}.
         * 
         * @param notificationRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationRules(java.util.Collection<NotificationRuleSummary>)
         */
        Builder notificationRules(Consumer<NotificationRuleSummary.Builder>... notificationRules);
    }

    static final class BuilderImpl extends CodestarNotificationsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<NotificationRuleSummary> notificationRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotificationRulesResponse model) {
            super(model);
            nextToken(model.nextToken);
            notificationRules(model.notificationRules);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<NotificationRuleSummary.Builder> getNotificationRules() {
            List<NotificationRuleSummary.Builder> result = NotificationRuleBatchCopier.copyToBuilder(this.notificationRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationRules(Collection<NotificationRuleSummary.BuilderImpl> notificationRules) {
            this.notificationRules = NotificationRuleBatchCopier.copyFromBuilder(notificationRules);
        }

        @Override
        public final Builder notificationRules(Collection<NotificationRuleSummary> notificationRules) {
            this.notificationRules = NotificationRuleBatchCopier.copy(notificationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationRules(NotificationRuleSummary... notificationRules) {
            notificationRules(Arrays.asList(notificationRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationRules(Consumer<NotificationRuleSummary.Builder>... notificationRules) {
            notificationRules(Stream.of(notificationRules).map(c -> NotificationRuleSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListNotificationRulesResponse build() {
            return new ListNotificationRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
