/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarnotifications.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codestarnotifications.model.CodestarNotificationsResponse;
import software.amazon.awssdk.services.codestarnotifications.model.DetailType;
import software.amazon.awssdk.services.codestarnotifications.model.EventTypeBatchCopier;
import software.amazon.awssdk.services.codestarnotifications.model.EventTypeSummary;
import software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleStatus;
import software.amazon.awssdk.services.codestarnotifications.model.TagsCopier;
import software.amazon.awssdk.services.codestarnotifications.model.TargetSummary;
import software.amazon.awssdk.services.codestarnotifications.model.TargetsBatchCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNotificationRuleResponse
extends CodestarNotificationsResponse
implements ToCopyableBuilder<Builder, DescribeNotificationRuleResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeNotificationRuleResponse.getter(DescribeNotificationRuleResponse::arn)).setter(DescribeNotificationRuleResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeNotificationRuleResponse.getter(DescribeNotificationRuleResponse::name)).setter(DescribeNotificationRuleResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<EventTypeSummary>> EVENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventTypes").getter(DescribeNotificationRuleResponse.getter(DescribeNotificationRuleResponse::eventTypes)).setter(DescribeNotificationRuleResponse.setter(Builder::eventTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventTypeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Resource").getter(DescribeNotificationRuleResponse.getter(DescribeNotificationRuleResponse::resource)).setter(DescribeNotificationRuleResponse.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()}).build();
    private static final SdkField<List<TargetSummary>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(DescribeNotificationRuleResponse.getter(DescribeNotificationRuleResponse::targets)).setter(DescribeNotificationRuleResponse.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DETAIL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetailType").getter(DescribeNotificationRuleResponse.getter(DescribeNotificationRuleResponse::detailTypeAsString)).setter(DescribeNotificationRuleResponse.setter(Builder::detailType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailType").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(DescribeNotificationRuleResponse.getter(DescribeNotificationRuleResponse::createdBy)).setter(DescribeNotificationRuleResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeNotificationRuleResponse.getter(DescribeNotificationRuleResponse::statusAsString)).setter(DescribeNotificationRuleResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(DescribeNotificationRuleResponse.getter(DescribeNotificationRuleResponse::createdTimestamp)).setter(DescribeNotificationRuleResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTimestamp").getter(DescribeNotificationRuleResponse.getter(DescribeNotificationRuleResponse::lastModifiedTimestamp)).setter(DescribeNotificationRuleResponse.setter(Builder::lastModifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimestamp").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribeNotificationRuleResponse.getter(DescribeNotificationRuleResponse::tags)).setter(DescribeNotificationRuleResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, EVENT_TYPES_FIELD, RESOURCE_FIELD, TARGETS_FIELD, DETAIL_TYPE_FIELD, CREATED_BY_FIELD, STATUS_FIELD, CREATED_TIMESTAMP_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeNotificationRuleResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String name;
    private final List<EventTypeSummary> eventTypes;
    private final String resource;
    private final List<TargetSummary> targets;
    private final String detailType;
    private final String createdBy;
    private final String status;
    private final Instant createdTimestamp;
    private final Instant lastModifiedTimestamp;
    private final Map<String, String> tags;

    private DescribeNotificationRuleResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.eventTypes = builder.eventTypes;
        this.resource = builder.resource;
        this.targets = builder.targets;
        this.detailType = builder.detailType;
        this.createdBy = builder.createdBy;
        this.status = builder.status;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasEventTypes() {
        return this.eventTypes != null && !(this.eventTypes instanceof SdkAutoConstructList);
    }

    public final List<EventTypeSummary> eventTypes() {
        return this.eventTypes;
    }

    public final String resource() {
        return this.resource;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<TargetSummary> targets() {
        return this.targets;
    }

    public final DetailType detailType() {
        return DetailType.fromValue(this.detailType);
    }

    public final String detailTypeAsString() {
        return this.detailType;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final NotificationRuleStatus status() {
        return NotificationRuleStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant lastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventTypes() ? this.eventTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.detailTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotificationRuleResponse)) {
            return false;
        }
        DescribeNotificationRuleResponse other = (DescribeNotificationRuleResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && this.hasEventTypes() == other.hasEventTypes() && Objects.equals(this.eventTypes(), other.eventTypes()) && Objects.equals(this.resource(), other.resource()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.detailTypeAsString(), other.detailTypeAsString()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.lastModifiedTimestamp(), other.lastModifiedTimestamp()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeNotificationRuleResponse").add("Arn", (Object)this.arn()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("EventTypes", this.hasEventTypes() ? this.eventTypes() : null).add("Resource", (Object)this.resource()).add("Targets", this.hasTargets() ? this.targets() : null).add("DetailType", (Object)this.detailTypeAsString()).add("CreatedBy", (Object)this.createdBy()).add("Status", (Object)this.statusAsString()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("LastModifiedTimestamp", (Object)this.lastModifiedTimestamp()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "EventTypes": {
                return Optional.ofNullable(clazz.cast(this.eventTypes()));
            }
            case "Resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "DetailType": {
                return Optional.ofNullable(clazz.cast(this.detailTypeAsString()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "LastModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimestamp()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("EventTypes", EVENT_TYPES_FIELD);
        map.put("Resource", RESOURCE_FIELD);
        map.put("Targets", TARGETS_FIELD);
        map.put("DetailType", DETAIL_TYPE_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("LastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeNotificationRuleResponse, T> g) {
        return obj -> g.apply((DescribeNotificationRuleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodestarNotificationsResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private List<EventTypeSummary> eventTypes = DefaultSdkAutoConstructList.getInstance();
        private String resource;
        private List<TargetSummary> targets = DefaultSdkAutoConstructList.getInstance();
        private String detailType;
        private String createdBy;
        private String status;
        private Instant createdTimestamp;
        private Instant lastModifiedTimestamp;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotificationRuleResponse model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.eventTypes(model.eventTypes);
            this.resource(model.resource);
            this.targets(model.targets);
            this.detailType(model.detailType);
            this.createdBy(model.createdBy);
            this.status(model.status);
            this.createdTimestamp(model.createdTimestamp);
            this.lastModifiedTimestamp(model.lastModifiedTimestamp);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<EventTypeSummary.Builder> getEventTypes() {
            List<EventTypeSummary.Builder> result = EventTypeBatchCopier.copyToBuilder(this.eventTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventTypes(Collection<EventTypeSummary.BuilderImpl> eventTypes) {
            this.eventTypes = EventTypeBatchCopier.copyFromBuilder(eventTypes);
        }

        @Override
        public final Builder eventTypes(Collection<EventTypeSummary> eventTypes) {
            this.eventTypes = EventTypeBatchCopier.copy(eventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypes(EventTypeSummary ... eventTypes) {
            this.eventTypes(Arrays.asList(eventTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypes(Consumer<EventTypeSummary.Builder> ... eventTypes) {
            this.eventTypes(Stream.of(eventTypes).map(c -> (EventTypeSummary)((EventTypeSummary.Builder)EventTypeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResource() {
            return this.resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final List<TargetSummary.Builder> getTargets() {
            List<TargetSummary.Builder> result = TargetsBatchCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<TargetSummary.BuilderImpl> targets) {
            this.targets = TargetsBatchCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Collection<TargetSummary> targets) {
            this.targets = TargetsBatchCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(TargetSummary ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<TargetSummary.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (TargetSummary)((TargetSummary.Builder)TargetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDetailType() {
            return this.detailType;
        }

        public final void setDetailType(String detailType) {
            this.detailType = detailType;
        }

        @Override
        public final Builder detailType(String detailType) {
            this.detailType = detailType;
            return this;
        }

        @Override
        public final Builder detailType(DetailType detailType) {
            this.detailType(detailType == null ? null : detailType.toString());
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NotificationRuleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return this.lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeNotificationRuleResponse build() {
            return new DescribeNotificationRuleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodestarNotificationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNotificationRuleResponse> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder eventTypes(Collection<EventTypeSummary> var1);

        public Builder eventTypes(EventTypeSummary ... var1);

        public Builder eventTypes(Consumer<EventTypeSummary.Builder> ... var1);

        public Builder resource(String var1);

        public Builder targets(Collection<TargetSummary> var1);

        public Builder targets(TargetSummary ... var1);

        public Builder targets(Consumer<TargetSummary.Builder> ... var1);

        public Builder detailType(String var1);

        public Builder detailType(DetailType var1);

        public Builder createdBy(String var1);

        public Builder status(String var1);

        public Builder status(NotificationRuleStatus var1);

        public Builder createdTimestamp(Instant var1);

        public Builder lastModifiedTimestamp(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

