/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarnotifications;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codestarnotifications.CodestarNotificationsClient;
import software.amazon.awssdk.services.codestarnotifications.CodestarNotificationsClientBuilder;
import software.amazon.awssdk.services.codestarnotifications.CodestarNotificationsServiceClientConfiguration;
import software.amazon.awssdk.services.codestarnotifications.DefaultCodestarNotificationsBaseClientBuilder;
import software.amazon.awssdk.services.codestarnotifications.DefaultCodestarNotificationsClient;
import software.amazon.awssdk.services.codestarnotifications.endpoints.CodestarNotificationsEndpointProvider;

@SdkInternalApi
final class DefaultCodestarNotificationsClientBuilder
extends DefaultCodestarNotificationsBaseClientBuilder<CodestarNotificationsClientBuilder, CodestarNotificationsClient>
implements CodestarNotificationsClientBuilder {
    DefaultCodestarNotificationsClientBuilder() {
    }

    @Override
    public DefaultCodestarNotificationsClientBuilder endpointProvider(CodestarNotificationsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodestarNotificationsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodestarNotificationsClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CodestarNotificationsServiceClientConfiguration serviceClientConfiguration = CodestarNotificationsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCodestarNotificationsClient(serviceClientConfiguration, clientConfiguration);
    }
}

