/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarnotifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTargetsResponse extends CodestarNotificationsResponse implements
        ToCopyableBuilder<ListTargetsResponse.Builder, ListTargetsResponse> {
    private static final SdkField<List<TargetSummary>> TARGETS_FIELD = SdkField
            .<List<TargetSummary>> builder(MarshallingType.LIST)
            .memberName("Targets")
            .getter(getter(ListTargetsResponse::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTargetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGETS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TargetSummary> targets;

    private final String nextToken;

    private ListTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.targets = builder.targets;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Targets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of notification rule targets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of notification rule targets.
     */
    public final List<TargetSummary> targets() {
        return targets;
    }

    /**
     * <p>
     * An enumeration token that can be used in a request to return the next batch of results.
     * </p>
     * 
     * @return An enumeration token that can be used in a request to return the next batch of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTargetsResponse)) {
            return false;
        }
        ListTargetsResponse other = (ListTargetsResponse) obj;
        return hasTargets() == other.hasTargets() && Objects.equals(targets(), other.targets())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTargetsResponse").add("Targets", hasTargets() ? targets() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTargetsResponse, T> g) {
        return obj -> g.apply((ListTargetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodestarNotificationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTargetsResponse> {
        /**
         * <p>
         * The list of notification rule targets.
         * </p>
         * 
         * @param targets
         *        The list of notification rule targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<TargetSummary> targets);

        /**
         * <p>
         * The list of notification rule targets.
         * </p>
         * 
         * @param targets
         *        The list of notification rule targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(TargetSummary... targets);

        /**
         * <p>
         * The list of notification rule targets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TargetSummary>.Builder} avoiding the need
         * to create one manually via {@link List<TargetSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TargetSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #targets(List<TargetSummary>)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link List<TargetSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(List<TargetSummary>)
         */
        Builder targets(Consumer<TargetSummary.Builder>... targets);

        /**
         * <p>
         * An enumeration token that can be used in a request to return the next batch of results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that can be used in a request to return the next batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodestarNotificationsResponse.BuilderImpl implements Builder {
        private List<TargetSummary> targets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTargetsResponse model) {
            super(model);
            targets(model.targets);
            nextToken(model.nextToken);
        }

        public final Collection<TargetSummary.Builder> getTargets() {
            if (targets instanceof SdkAutoConstructList) {
                return null;
            }
            return targets != null ? targets.stream().map(TargetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<TargetSummary> targets) {
            this.targets = TargetsBatchCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(TargetSummary... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<TargetSummary.Builder>... targets) {
            targets(Stream.of(targets).map(c -> TargetSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<TargetSummary.BuilderImpl> targets) {
            this.targets = TargetsBatchCopier.copyFromBuilder(targets);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTargetsResponse build() {
            return new ListTargetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
