/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarnotifications.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubscribeRequest extends CodestarNotificationsRequest implements
        ToCopyableBuilder<SubscribeRequest.Builder, SubscribeRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubscribeRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Target> TARGET_FIELD = SdkField.<Target> builder(MarshallingType.SDK_POJO)
            .getter(getter(SubscribeRequest::target)).setter(setter(Builder::target)).constructor(Target::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubscribeRequest::clientRequestToken)).setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TARGET_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD));

    private final String arn;

    private final Target target;

    private final String clientRequestToken;

    private SubscribeRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.target = builder.target;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the notification rule for which you want to create the association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the notification rule for which you want to create the association.
     */
    public String arn() {
        return arn;
    }

    /**
     * Returns the value of the Target property for this object.
     * 
     * @return The value of the Target property for this object.
     */
    public Target target() {
        return target;
    }

    /**
     * <p>
     * An enumeration token that, when provided in a request, returns the next batch of the results.
     * </p>
     * 
     * @return An enumeration token that, when provided in a request, returns the next batch of the results.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribeRequest)) {
            return false;
        }
        SubscribeRequest other = (SubscribeRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(target(), other.target())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SubscribeRequest").add("Arn", arn()).add("Target", target())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubscribeRequest, T> g) {
        return obj -> g.apply((SubscribeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodestarNotificationsRequest.Builder, SdkPojo, CopyableBuilder<Builder, SubscribeRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the notification rule for which you want to create the association.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the notification rule for which you want to create the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Sets the value of the Target property for this object.
         *
         * @param target
         *        The new value for the Target property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(Target target);

        /**
         * Sets the value of the Target property for this object.
         *
         * This is a convenience that creates an instance of the {@link Target.Builder} avoiding the need to create one
         * manually via {@link Target#builder()}.
         *
         * When the {@link Consumer} completes, {@link Target.Builder#build()} is called immediately and its result is
         * passed to {@link #target(Target)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link Target.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(Target)
         */
        default Builder target(Consumer<Target.Builder> target) {
            return target(Target.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * An enumeration token that, when provided in a request, returns the next batch of the results.
         * </p>
         * 
         * @param clientRequestToken
         *        An enumeration token that, when provided in a request, returns the next batch of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodestarNotificationsRequest.BuilderImpl implements Builder {
        private String arn;

        private Target target;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribeRequest model) {
            super(model);
            arn(model.arn);
            target(model.target);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Target.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        @Override
        public final Builder target(Target target) {
            this.target = target;
            return this;
        }

        public final void setTarget(Target.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubscribeRequest build() {
            return new SubscribeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
