/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarnotifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codestarnotifications.model.CodestarNotificationsResponse;
import software.amazon.awssdk.services.codestarnotifications.model.EventTypeBatchCopier;
import software.amazon.awssdk.services.codestarnotifications.model.EventTypeSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEventTypesResponse
extends CodestarNotificationsResponse
implements ToCopyableBuilder<Builder, ListEventTypesResponse> {
    private static final SdkField<List<EventTypeSummary>> EVENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListEventTypesResponse.getter(ListEventTypesResponse::eventTypes)).setter(ListEventTypesResponse.setter(Builder::eventTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventTypeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListEventTypesResponse.getter(ListEventTypesResponse::nextToken)).setter(ListEventTypesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPES_FIELD, NEXT_TOKEN_FIELD));
    private final List<EventTypeSummary> eventTypes;
    private final String nextToken;

    private ListEventTypesResponse(BuilderImpl builder) {
        super(builder);
        this.eventTypes = builder.eventTypes;
        this.nextToken = builder.nextToken;
    }

    public List<EventTypeSummary> eventTypes() {
        return this.eventTypes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventTypesResponse)) {
            return false;
        }
        ListEventTypesResponse other = (ListEventTypesResponse)((Object)obj);
        return Objects.equals(this.eventTypes(), other.eventTypes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListEventTypesResponse").add("EventTypes", this.eventTypes()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventTypes": {
                return Optional.ofNullable(clazz.cast(this.eventTypes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEventTypesResponse, T> g) {
        return obj -> g.apply((ListEventTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodestarNotificationsResponse.BuilderImpl
    implements Builder {
        private List<EventTypeSummary> eventTypes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventTypesResponse model) {
            super(model);
            this.eventTypes(model.eventTypes);
            this.nextToken(model.nextToken);
        }

        public final Collection<EventTypeSummary.Builder> getEventTypes() {
            return this.eventTypes != null ? (Collection)this.eventTypes.stream().map(EventTypeSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventTypes(Collection<EventTypeSummary> eventTypes) {
            this.eventTypes = EventTypeBatchCopier.copy(eventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypes(EventTypeSummary ... eventTypes) {
            this.eventTypes(Arrays.asList(eventTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypes(Consumer<EventTypeSummary.Builder> ... eventTypes) {
            this.eventTypes(Stream.of(eventTypes).map(c -> (EventTypeSummary)((EventTypeSummary.Builder)EventTypeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventTypes(Collection<EventTypeSummary.BuilderImpl> eventTypes) {
            this.eventTypes = EventTypeBatchCopier.copyFromBuilder(eventTypes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEventTypesResponse build() {
            return new ListEventTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodestarNotificationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEventTypesResponse> {
        public Builder eventTypes(Collection<EventTypeSummary> var1);

        public Builder eventTypes(EventTypeSummary ... var1);

        public Builder eventTypes(Consumer<EventTypeSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

