/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarconnections.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codestarconnections.model.CodeStarConnectionsResponse;
import software.amazon.awssdk.services.codestarconnections.model.RepositorySyncDefinition;
import software.amazon.awssdk.services.codestarconnections.model.RepositorySyncDefinitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRepositorySyncDefinitionsResponse
extends CodeStarConnectionsResponse
implements ToCopyableBuilder<Builder, ListRepositorySyncDefinitionsResponse> {
    private static final SdkField<List<RepositorySyncDefinition>> REPOSITORY_SYNC_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RepositorySyncDefinitions").getter(ListRepositorySyncDefinitionsResponse.getter(ListRepositorySyncDefinitionsResponse::repositorySyncDefinitions)).setter(ListRepositorySyncDefinitionsResponse.setter(Builder::repositorySyncDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositorySyncDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RepositorySyncDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRepositorySyncDefinitionsResponse.getter(ListRepositorySyncDefinitionsResponse::nextToken)).setter(ListRepositorySyncDefinitionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_SYNC_DEFINITIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRepositorySyncDefinitionsResponse.memberNameToFieldInitializer();
    private final List<RepositorySyncDefinition> repositorySyncDefinitions;
    private final String nextToken;

    private ListRepositorySyncDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.repositorySyncDefinitions = builder.repositorySyncDefinitions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRepositorySyncDefinitions() {
        return this.repositorySyncDefinitions != null && !(this.repositorySyncDefinitions instanceof SdkAutoConstructList);
    }

    public final List<RepositorySyncDefinition> repositorySyncDefinitions() {
        return this.repositorySyncDefinitions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRepositorySyncDefinitions() ? this.repositorySyncDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositorySyncDefinitionsResponse)) {
            return false;
        }
        ListRepositorySyncDefinitionsResponse other = (ListRepositorySyncDefinitionsResponse)((Object)obj);
        return this.hasRepositorySyncDefinitions() == other.hasRepositorySyncDefinitions() && Objects.equals(this.repositorySyncDefinitions(), other.repositorySyncDefinitions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRepositorySyncDefinitionsResponse").add("RepositorySyncDefinitions", this.hasRepositorySyncDefinitions() ? this.repositorySyncDefinitions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RepositorySyncDefinitions": {
                return Optional.ofNullable(clazz.cast(this.repositorySyncDefinitions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RepositorySyncDefinitions", REPOSITORY_SYNC_DEFINITIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRepositorySyncDefinitionsResponse, T> g) {
        return obj -> g.apply((ListRepositorySyncDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeStarConnectionsResponse.BuilderImpl
    implements Builder {
        private List<RepositorySyncDefinition> repositorySyncDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRepositorySyncDefinitionsResponse model) {
            super(model);
            this.repositorySyncDefinitions(model.repositorySyncDefinitions);
            this.nextToken(model.nextToken);
        }

        public final List<RepositorySyncDefinition.Builder> getRepositorySyncDefinitions() {
            List<RepositorySyncDefinition.Builder> result = RepositorySyncDefinitionListCopier.copyToBuilder(this.repositorySyncDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepositorySyncDefinitions(Collection<RepositorySyncDefinition.BuilderImpl> repositorySyncDefinitions) {
            this.repositorySyncDefinitions = RepositorySyncDefinitionListCopier.copyFromBuilder(repositorySyncDefinitions);
        }

        @Override
        public final Builder repositorySyncDefinitions(Collection<RepositorySyncDefinition> repositorySyncDefinitions) {
            this.repositorySyncDefinitions = RepositorySyncDefinitionListCopier.copy(repositorySyncDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositorySyncDefinitions(RepositorySyncDefinition ... repositorySyncDefinitions) {
            this.repositorySyncDefinitions(Arrays.asList(repositorySyncDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositorySyncDefinitions(Consumer<RepositorySyncDefinition.Builder> ... repositorySyncDefinitions) {
            this.repositorySyncDefinitions(Stream.of(repositorySyncDefinitions).map(c -> (RepositorySyncDefinition)((RepositorySyncDefinition.Builder)RepositorySyncDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRepositorySyncDefinitionsResponse build() {
            return new ListRepositorySyncDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeStarConnectionsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRepositorySyncDefinitionsResponse> {
        public Builder repositorySyncDefinitions(Collection<RepositorySyncDefinition> var1);

        public Builder repositorySyncDefinitions(RepositorySyncDefinition ... var1);

        public Builder repositorySyncDefinitions(Consumer<RepositorySyncDefinition.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

