/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarconnections;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codestarconnections.CodeStarConnectionsAsyncClient;
import software.amazon.awssdk.services.codestarconnections.CodeStarConnectionsAsyncClientBuilder;
import software.amazon.awssdk.services.codestarconnections.CodeStarConnectionsServiceClientConfiguration;
import software.amazon.awssdk.services.codestarconnections.DefaultCodeStarConnectionsAsyncClient;
import software.amazon.awssdk.services.codestarconnections.DefaultCodeStarConnectionsBaseClientBuilder;
import software.amazon.awssdk.services.codestarconnections.endpoints.CodeStarConnectionsEndpointProvider;

@SdkInternalApi
final class DefaultCodeStarConnectionsAsyncClientBuilder
extends DefaultCodeStarConnectionsBaseClientBuilder<CodeStarConnectionsAsyncClientBuilder, CodeStarConnectionsAsyncClient>
implements CodeStarConnectionsAsyncClientBuilder {
    DefaultCodeStarConnectionsAsyncClientBuilder() {
    }

    @Override
    public DefaultCodeStarConnectionsAsyncClientBuilder endpointProvider(CodeStarConnectionsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeStarConnectionsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCodeStarConnectionsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        CodeStarConnectionsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodeStarConnectionsAsyncClient client = new DefaultCodeStarConnectionsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodeStarConnectionsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodeStarConnectionsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

