/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestar;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codestar.CodeStarClient;
import software.amazon.awssdk.services.codestar.CodeStarClientBuilder;
import software.amazon.awssdk.services.codestar.CodeStarServiceClientConfiguration;
import software.amazon.awssdk.services.codestar.DefaultCodeStarBaseClientBuilder;
import software.amazon.awssdk.services.codestar.DefaultCodeStarClient;
import software.amazon.awssdk.services.codestar.endpoints.CodeStarEndpointProvider;

@SdkInternalApi
final class DefaultCodeStarClientBuilder
extends DefaultCodeStarBaseClientBuilder<CodeStarClientBuilder, CodeStarClient>
implements CodeStarClientBuilder {
    DefaultCodeStarClientBuilder() {
    }

    @Override
    public DefaultCodeStarClientBuilder endpointProvider(CodeStarEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeStarClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodeStarClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CodeStarServiceClientConfiguration serviceClientConfiguration = CodeStarServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCodeStarClient(serviceClientConfiguration, clientConfiguration);
    }
}

